/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.jobstore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.IsLocked;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsNavigableSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.JobPersistenceException;
import com.helger.quartz.ObjectAlreadyExistsException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.quartz.impl.matchers.StringMatcher;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.IJobStore;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.ISchedulerSignaler;
import com.helger.quartz.spi.TriggerFiredBundle;
import com.helger.quartz.spi.TriggerFiredResult;
import com.helger.quartz.utils.Key;
import com.helger.schedule.jobstore.JobWrapper;
import com.helger.schedule.jobstore.TriggerWrapper;
import com.helger.schedule.jobstore.TriggerWrapperComparator;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseJobStore
implements IJobStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseJobStore.class);
    private static final AtomicLong s_aFiredTriggerRecordID = new AtomicLong(System.currentTimeMillis());
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private ISchedulerSignaler m_aSignaler;
    private final ICommonsMap<JobKey, JobWrapper> m_aJobsByKey = new CommonsHashMap<JobKey, JobWrapper>(1000);
    private final ICommonsMap<TriggerKey, TriggerWrapper> m_aTriggersByKey = new CommonsHashMap<TriggerKey, TriggerWrapper>(1000);
    private final ICommonsMap<String, ICommonsMap<JobKey, JobWrapper>> m_aJobsByGroup = new CommonsHashMap<String, ICommonsMap<JobKey, JobWrapper>>(25);
    private final ICommonsMap<String, ICommonsMap<TriggerKey, TriggerWrapper>> m_aTriggersByGroup = new CommonsHashMap<String, ICommonsMap<TriggerKey, TriggerWrapper>>(25);
    private final ICommonsNavigableSet<TriggerWrapper> m_aTimeTriggers = new CommonsTreeSet<TriggerWrapperComparator>(new TriggerWrapperComparator());
    private final ICommonsMap<String, ICalendar> m_aCalendarsByName = new CommonsHashMap<String, ICalendar>(25);
    private final ICommonsList<TriggerWrapper> m_aTriggers = new CommonsArrayList<int>(1000);
    private final ICommonsSet<String> m_aPausedTriggerGroups = new CommonsHashSet<String>();
    private final ICommonsSet<String> m_aPausedJobGroups = new CommonsHashSet<String>();
    private final ICommonsSet<JobKey> m_aBlockedJobs = new CommonsHashSet<JobKey>();
    private long m_nMisfireThreshold = 5000L;

    @Override
    public void initialize(IClassLoadHelper iClassLoadHelper, ISchedulerSignaler iSchedulerSignaler) {
        this.m_aRWLock.writeLockedGet(() -> {
            this.m_aSignaler = iSchedulerSignaler;
            return this.m_aSignaler;
        });
        LOGGER.info("ph-schedule JobStore initialized.");
    }

    @Override
    public void schedulerStarted() {
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    @Nonnegative
    public long getMisfireThreshold() {
        return this.m_aRWLock.readLockedLong(() -> this.m_nMisfireThreshold);
    }

    public void setMisfireThreshold(@Nonnegative long l) {
        ValueEnforcer.isGT0(l, "MisfireThreshold");
        this.m_aRWLock.writeLockedLong(() -> {
            this.m_nMisfireThreshold = l;
            return this.m_nMisfireThreshold;
        });
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean supportsPersistence() {
        return false;
    }

    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        ICommonsSet<Key> iCommonsSet;
        for (String string : this.getTriggerGroupNames()) {
            iCommonsSet = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
            for (TriggerKey key : iCommonsSet) {
                this.removeTrigger(key);
            }
        }
        for (String string : this.getJobGroupNames()) {
            iCommonsSet = this.getJobKeys(GroupMatcher.jobGroupEquals(string));
            for (JobKey jobKey : iCommonsSet) {
                this.removeJob(jobKey);
            }
        }
        for (String string : this.getCalendarNames()) {
            this.removeCalendar(string);
        }
    }

    @Override
    public void storeJobAndTrigger(IJobDetail iJobDetail, IOperableTrigger iOperableTrigger) throws JobPersistenceException {
        this.storeJob(iJobDetail, false);
        this.storeTrigger(iOperableTrigger, false);
    }

    @Override
    public void storeJob(IJobDetail iJobDetail, boolean bl) throws ObjectAlreadyExistsException {
        JobKey jobKey = iJobDetail.getKey();
        boolean bl2 = false;
        JobWrapper jobWrapper = this.m_aRWLock.readLockedGet(() -> (JobWrapper)this.m_aJobsByKey.get(jobKey));
        if (jobWrapper != null) {
            if (!bl) {
                throw new ObjectAlreadyExistsException(iJobDetail);
            }
            bl2 = true;
        }
        if (!bl2) {
            this.m_aRWLock.writeLocked(() -> {
                String string2 = jobKey.getGroup();
                ICommonsMap iCommonsMap = this.m_aJobsByGroup.computeIfAbsent(string2, string -> new CommonsHashMap(100));
                JobWrapper jobWrapper = new JobWrapper((IJobDetail)iJobDetail.getClone());
                iCommonsMap.put(jobKey, jobWrapper);
                this.m_aJobsByKey.put(jobKey, jobWrapper);
            });
        } else {
            this.m_aRWLock.writeLocked(() -> jobWrapper.setJobDetail((IJobDetail)iJobDetail.getClone()));
        }
    }

    @Override
    public boolean removeJob(JobKey jobKey) {
        boolean bl = false;
        ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
        for (IOperableTrigger iOperableTrigger : iCommonsList) {
            this.removeTrigger(iOperableTrigger.getKey());
            bl = true;
        }
        boolean bl2 = bl;
        return this.m_aRWLock.writeLockedBoolean(() -> {
            boolean bl2;
            boolean bl3 = bl2 = this.m_aJobsByKey.remove(jobKey) != null;
            if (!bl2 && !bl2) {
                return false;
            }
            ICommonsMap iCommonsMap = (ICommonsMap)this.m_aJobsByGroup.get(jobKey.getGroup());
            if (iCommonsMap != null) {
                iCommonsMap.remove(jobKey);
                if (iCommonsMap.isEmpty()) {
                    this.m_aJobsByGroup.remove(jobKey.getGroup());
                }
            }
            return true;
        });
    }

    @Override
    public boolean removeJobs(@Nonnull List<JobKey> list) throws JobPersistenceException {
        boolean bl = true;
        for (JobKey jobKey : list) {
            if (this.removeJob(jobKey)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean removeTriggers(@Nonnull List<TriggerKey> list) throws JobPersistenceException {
        boolean bl = true;
        for (TriggerKey triggerKey : list) {
            if (this.removeTrigger(triggerKey)) continue;
            bl = false;
        }
        return bl;
    }

    @Override
    public void storeJobsAndTriggers(Map<IJobDetail, Set<? extends ITrigger>> map, boolean bl) throws JobPersistenceException {
        if (!bl) {
            for (Map.Entry<IJobDetail, Set<? extends ITrigger>> entry : map.entrySet()) {
                IJobDetail iJobDetail = entry.getKey();
                if (this.checkExists(iJobDetail.getKey())) {
                    throw new ObjectAlreadyExistsException(iJobDetail);
                }
                for (ITrigger iTrigger : entry.getValue()) {
                    if (!this.checkExists(iTrigger.getKey())) continue;
                    throw new ObjectAlreadyExistsException(iTrigger);
                }
            }
        }
        for (Map.Entry<IJobDetail, Set<? extends ITrigger>> entry : map.entrySet()) {
            this.storeJob(entry.getKey(), true);
            for (ITrigger iTrigger : entry.getValue()) {
                this.storeTrigger((IOperableTrigger)iTrigger, true);
            }
        }
    }

    @Override
    public void storeTrigger(@Nonnull IOperableTrigger iOperableTrigger, boolean bl) throws JobPersistenceException {
        TriggerKey triggerKey = iOperableTrigger.getKey();
        if (this.checkExists(triggerKey)) {
            if (!bl) {
                throw new ObjectAlreadyExistsException(iOperableTrigger);
            }
            this._removeTrigger(triggerKey, false);
        }
        if (this.retrieveJob(iOperableTrigger.getJobKey()) == null) {
            throw new JobPersistenceException("The job (" + iOperableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
        }
        TriggerWrapper triggerWrapper = new TriggerWrapper(iOperableTrigger.getClone());
        this.m_aRWLock.writeLocked(() -> {
            this.m_aTriggers.add(triggerWrapper);
            String string2 = triggerKey.getGroup();
            ICommonsMap iCommonsMap = this.m_aTriggersByGroup.computeIfAbsent(string2, string -> new CommonsHashMap(100));
            iCommonsMap.put(triggerKey, triggerWrapper);
            this.m_aTriggersByKey.put(triggerKey, triggerWrapper);
            if (this.m_aPausedTriggerGroups.contains(string2) || this.m_aPausedJobGroups.contains(iOperableTrigger.getJobKey().getGroup())) {
                triggerWrapper.setState(4);
                if (this.m_aBlockedJobs.contains(triggerWrapper.getJobKey())) {
                    triggerWrapper.setState(6);
                }
            } else if (this.m_aBlockedJobs.contains(triggerWrapper.getJobKey())) {
                triggerWrapper.setState(5);
            } else {
                this.m_aTimeTriggers.add(triggerWrapper);
            }
        });
    }

    @Override
    public boolean removeTrigger(@Nonnull TriggerKey triggerKey) {
        return this._removeTrigger(triggerKey, true);
    }

    @IsLocked(value=ELockType.WRITE)
    private boolean _removeTrigger(@Nonnull TriggerKey triggerKey, boolean bl) {
        return this.m_aRWLock.writeLockedBoolean(() -> {
            if (this.m_aTriggersByKey.remove(triggerKey) == null) {
                return false;
            }
            ICommonsMap iCommonsMap = (ICommonsMap)this.m_aTriggersByGroup.get(triggerKey.getGroup());
            if (iCommonsMap != null) {
                iCommonsMap.remove(triggerKey);
                if (iCommonsMap.isEmpty()) {
                    this.m_aTriggersByGroup.remove(triggerKey.getGroup());
                }
            }
            TriggerWrapper triggerWrapper = null;
            Iterator iterator = this.m_aTriggers.iterator();
            while (iterator.hasNext()) {
                triggerWrapper = (TriggerWrapper)iterator.next();
                if (!triggerKey.equals(triggerWrapper.getTriggerKey())) continue;
                iterator.remove();
                break;
            }
            this.m_aTimeTriggers.remove(triggerWrapper);
            if (bl) {
                JobWrapper jobWrapper = (JobWrapper)this.m_aJobsByKey.get(triggerWrapper.getJobKey());
                ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(triggerWrapper.getJobKey());
                if ((iCommonsList == null || iCommonsList.isEmpty()) && !jobWrapper.getJobDetail().isDurable() && this.removeJob(jobWrapper.getJobKey())) {
                    this.m_aSignaler.notifySchedulerListenersJobDeleted(jobWrapper.getJobKey());
                }
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, IOperableTrigger iOperableTrigger) throws JobPersistenceException {
        TriggerWrapper triggerWrapper;
        this.m_aRWLock.writeLock().lock();
        try {
            triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.remove(triggerKey);
            if (triggerWrapper == null) {
                boolean bl = false;
                return bl;
            }
            if (!triggerWrapper.getTrigger().getJobKey().equals(iOperableTrigger.getJobKey())) {
                throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
            }
            ICommonsMap iCommonsMap = (ICommonsMap)this.m_aTriggersByGroup.get(triggerKey.getGroup());
            if (iCommonsMap != null) {
                iCommonsMap.remove(triggerKey);
                if (iCommonsMap.isEmpty()) {
                    this.m_aTriggersByGroup.remove(triggerKey.getGroup());
                }
            }
            triggerWrapper = null;
            Iterator iterator = this.m_aTriggers.iterator();
            while (iterator.hasNext()) {
                triggerWrapper = (TriggerWrapper)iterator.next();
                if (!triggerKey.equals(triggerWrapper.getTriggerKey())) continue;
                iterator.remove();
                break;
            }
            this.m_aTimeTriggers.remove(triggerWrapper);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        try {
            this.storeTrigger(iOperableTrigger, false);
        }
        catch (JobPersistenceException jobPersistenceException) {
            this.storeTrigger(triggerWrapper.getTrigger(), false);
            throw jobPersistenceException;
        }
        return true;
    }

    @Override
    public IJobDetail retrieveJob(JobKey jobKey) {
        return this.m_aRWLock.readLockedGet(() -> {
            JobWrapper jobWrapper = (JobWrapper)this.m_aJobsByKey.get(jobKey);
            return jobWrapper != null ? (IJobDetail)jobWrapper.getJobDetail().getClone() : null;
        });
    }

    @Override
    public IOperableTrigger retrieveTrigger(TriggerKey triggerKey) {
        return this.m_aRWLock.readLockedGet(() -> {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
            return triggerWrapper != null ? triggerWrapper.getTrigger().getClone() : null;
        });
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aJobsByKey.containsKey(jobKey));
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aTriggersByKey.containsKey(triggerKey));
    }

    @Override
    @Nonnull
    public ITrigger.ETriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        return this.m_aRWLock.readLockedGet(() -> {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
            if (triggerWrapper == null) {
                return ITrigger.ETriggerState.NONE;
            }
            if (triggerWrapper.getState() == 3) {
                return ITrigger.ETriggerState.COMPLETE;
            }
            if (triggerWrapper.getState() == 4) {
                return ITrigger.ETriggerState.PAUSED;
            }
            if (triggerWrapper.getState() == 6) {
                return ITrigger.ETriggerState.PAUSED;
            }
            if (triggerWrapper.getState() == 5) {
                return ITrigger.ETriggerState.BLOCKED;
            }
            if (triggerWrapper.getState() == 7) {
                return ITrigger.ETriggerState.ERROR;
            }
            return ITrigger.ETriggerState.NORMAL;
        });
    }

    @Override
    public void storeCalendar(String string, ICalendar iCalendar, boolean bl, boolean bl2) throws ObjectAlreadyExistsException {
        this.m_aRWLock.writeLockedThrowing(() -> {
            ICalendar iCalendar2 = (ICalendar)this.m_aCalendarsByName.get(string);
            if (iCalendar2 != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
                }
                this.m_aCalendarsByName.remove(string);
            }
            ICalendar iCalendar3 = iCalendar.getClone();
            this.m_aCalendarsByName.put(string, iCalendar3);
            if (iCalendar2 != null && bl2) {
                for (TriggerWrapper triggerWrapper : this.getTriggerWrappersForCalendar(string)) {
                    IOperableTrigger iOperableTrigger = triggerWrapper.getTrigger();
                    boolean bl3 = this.m_aTimeTriggers.remove(triggerWrapper);
                    iOperableTrigger.updateWithNewCalendar(iCalendar3, this.getMisfireThreshold());
                    if (!bl3) continue;
                    this.m_aTimeTriggers.add(triggerWrapper);
                }
            }
        });
    }

    @Override
    public boolean removeCalendar(String string) throws JobPersistenceException {
        this.m_aRWLock.readLockedThrowing(() -> {
            int n = 0;
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                IOperableTrigger iOperableTrigger = triggerWrapper.getTrigger();
                if (iOperableTrigger.getCalendarName() == null || !iOperableTrigger.getCalendarName().equals(string)) continue;
                ++n;
            }
            if (n > 0) {
                throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
            }
        });
        return this.m_aRWLock.writeLockedBoolean(() -> this.m_aCalendarsByName.remove(string) != null);
    }

    @Override
    public ICalendar retrieveCalendar(String string) {
        return this.m_aRWLock.readLockedGet(() -> {
            ICalendar iCalendar = (ICalendar)this.m_aCalendarsByName.get(string);
            return iCalendar != null ? iCalendar.getClone() : null;
        });
    }

    @Override
    public int getNumberOfJobs() {
        return this.m_aRWLock.readLockedInt(this.m_aJobsByKey::size);
    }

    @Override
    public int getNumberOfTriggers() {
        return this.m_aRWLock.readLockedInt(this.m_aTriggers::size);
    }

    @Override
    public int getNumberOfCalendars() {
        return this.m_aRWLock.readLockedInt(this.m_aCalendarsByName::size);
    }

    @Override
    public ICommonsSet<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) {
        CommonsHashSet<JobKey> commonsHashSet = new CommonsHashSet<JobKey>();
        StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
        String string = groupMatcher.getCompareToValue();
        this.m_aRWLock.readLocked(() -> {
            switch (eStringOperatorName) {
                case EQUALS: {
                    ICommonsMap iCommonsMap = (ICommonsMap)this.m_aJobsByGroup.get(string);
                    if (iCommonsMap == null) break;
                    for (JobWrapper jobWrapper : iCommonsMap.values()) {
                        if (jobWrapper == null) continue;
                        commonsHashSet.add(jobWrapper.getJobKey());
                    }
                    break;
                }
                default: {
                    for (Map.Entry entry : this.m_aJobsByGroup.entrySet()) {
                        if (!eStringOperatorName.evaluate((String)entry.getKey(), string) || entry.getValue() == null) continue;
                        for (JobWrapper jobWrapper : ((ICommonsMap)entry.getValue()).values()) {
                            if (jobWrapper == null) continue;
                            commonsHashSet.add(jobWrapper.getJobKey());
                        }
                    }
                }
            }
        });
        return commonsHashSet;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getCalendarNames() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aCalendarsByName.keySet()));
    }

    @Override
    public ICommonsSet<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        CommonsHashSet<TriggerKey> commonsHashSet = new CommonsHashSet<TriggerKey>();
        StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
        String string = groupMatcher.getCompareToValue();
        this.m_aRWLock.readLocked(() -> {
            switch (eStringOperatorName) {
                case EQUALS: {
                    ICommonsMap iCommonsMap = (ICommonsMap)this.m_aTriggersByGroup.get(string);
                    if (iCommonsMap == null) break;
                    for (TriggerWrapper triggerWrapper : iCommonsMap.values()) {
                        if (triggerWrapper == null) continue;
                        commonsHashSet.add(triggerWrapper.getTriggerKey());
                    }
                    break;
                }
                default: {
                    for (Map.Entry entry : this.m_aTriggersByGroup.entrySet()) {
                        if (!eStringOperatorName.evaluate((String)entry.getKey(), string) || entry.getValue() == null) continue;
                        for (TriggerWrapper triggerWrapper : ((ICommonsMap)entry.getValue()).values()) {
                            if (triggerWrapper == null) continue;
                            commonsHashSet.add(triggerWrapper.getTriggerKey());
                        }
                    }
                }
            }
        });
        return commonsHashSet;
    }

    @Override
    public ICommonsList<String> getJobGroupNames() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aJobsByGroup.keySet()));
    }

    @Override
    public ICommonsList<String> getTriggerGroupNames() {
        return this.m_aRWLock.readLockedGet(() -> new CommonsArrayList(this.m_aTriggersByGroup.keySet()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IOperableTrigger> getTriggersForJob(JobKey jobKey) {
        return this.m_aRWLock.readLockedGet(() -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                if (!triggerWrapper.getJobKey().equals(jobKey)) continue;
                commonsArrayList.add(triggerWrapper.getTrigger().getClone());
            }
            return commonsArrayList;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    protected ICommonsList<TriggerWrapper> getTriggerWrappersForJob(JobKey jobKey) {
        return this.m_aRWLock.readLockedGet(() -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                if (!triggerWrapper.getJobKey().equals(jobKey)) continue;
                commonsArrayList.add(triggerWrapper);
            }
            return commonsArrayList;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    protected ICommonsList<TriggerWrapper> getTriggerWrappersForCalendar(String string) {
        return this.m_aRWLock.readLockedGet(() -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                String string2 = triggerWrapper.getTrigger().getCalendarName();
                if (string2 == null || !string2.equals(string)) continue;
                commonsArrayList.add(triggerWrapper);
            }
            return commonsArrayList;
        });
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        TriggerWrapper triggerWrapper = this.m_aRWLock.readLockedGet(() -> (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey));
        if (triggerWrapper == null) {
            return;
        }
        if (triggerWrapper.getState() == 3) {
            return;
        }
        this.m_aRWLock.writeLocked(() -> {
            if (triggerWrapper.getState() == 5) {
                triggerWrapper.setState(6);
            } else {
                triggerWrapper.setState(4);
            }
            this.m_aTimeTriggers.remove(triggerWrapper);
        });
    }

    public ICommonsList<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
        this.m_aRWLock.writeLocked(() -> {
            switch (eStringOperatorName) {
                case EQUALS: {
                    if (!this.m_aPausedTriggerGroups.add(groupMatcher.getCompareToValue())) break;
                    commonsArrayList.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.m_aTriggersByGroup.keySet()) {
                        if (!eStringOperatorName.evaluate(string, groupMatcher.getCompareToValue()) || !this.m_aPausedTriggerGroups.add(groupMatcher.getCompareToValue())) continue;
                        commonsArrayList.add(string);
                    }
                }
            }
        });
        for (String string : commonsArrayList) {
            ICommonsSet<TriggerKey> iCommonsSet = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
            for (TriggerKey triggerKey : iCommonsSet) {
                this.pauseTrigger(triggerKey);
            }
        }
        return commonsArrayList;
    }

    @Override
    public void pauseJob(JobKey jobKey) {
        ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
        for (IOperableTrigger iOperableTrigger : iCommonsList) {
            this.pauseTrigger(iOperableTrigger.getKey());
        }
    }

    public ICommonsList<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
        this.m_aRWLock.writeLocked(() -> {
            switch (eStringOperatorName) {
                case EQUALS: {
                    if (!this.m_aPausedJobGroups.add(groupMatcher.getCompareToValue())) break;
                    commonsArrayList.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.m_aJobsByGroup.keySet()) {
                        if (!eStringOperatorName.evaluate(string, groupMatcher.getCompareToValue()) || !this.m_aPausedJobGroups.add(string)) continue;
                        commonsArrayList.add(string);
                    }
                }
            }
        });
        for (String string : commonsArrayList) {
            for (JobKey jobKey : this.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
                for (IOperableTrigger iOperableTrigger : iCommonsList) {
                    this.pauseTrigger(iOperableTrigger.getKey());
                }
            }
        }
        return commonsArrayList;
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        TriggerWrapper triggerWrapper = this.m_aRWLock.readLockedGet(() -> (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey));
        if (triggerWrapper == null) {
            return;
        }
        if (triggerWrapper.getState() != 4 && triggerWrapper.getState() != 6) {
            return;
        }
        this.m_aRWLock.writeLocked(() -> {
            IOperableTrigger iOperableTrigger = triggerWrapper.getTrigger();
            if (this.m_aBlockedJobs.contains(iOperableTrigger.getJobKey())) {
                triggerWrapper.setState(5);
            } else {
                triggerWrapper.setState(0);
            }
            this.applyMisfire(triggerWrapper);
            if (triggerWrapper.getState() == 0) {
                this.m_aTimeTriggers.add(triggerWrapper);
            }
        });
    }

    public ICommonsList<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        ICommonsSet<TriggerKey> iCommonsSet = this.getTriggerKeys(groupMatcher);
        for (TriggerKey triggerKey : iCommonsSet) {
            commonsHashSet.add(triggerKey.getGroup());
            if (!this.m_aRWLock.readLockedBoolean(() -> {
                String string;
                TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
                return triggerWrapper == null || !this.m_aPausedJobGroups.contains(string = triggerWrapper.getJobKey().getGroup());
            })) continue;
            this.resumeTrigger(triggerKey);
        }
        this.m_aRWLock.writeLocked(() -> {
            for (String string : commonsHashSet) {
                this.m_aPausedTriggerGroups.remove(string);
            }
        });
        return commonsHashSet.getCopyAsList();
    }

    @Override
    public void resumeJob(JobKey jobKey) {
        ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
        for (IOperableTrigger iOperableTrigger : iCommonsList) {
            this.resumeTrigger(iOperableTrigger.getKey());
        }
    }

    @Override
    public ICommonsCollection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        CommonsHashSet<String> commonsHashSet = new CommonsHashSet<String>();
        ICommonsSet<JobKey> iCommonsSet = this.getJobKeys(groupMatcher);
        this.m_aRWLock.readLocked(() -> {
            for (String string : this.m_aPausedJobGroups) {
                if (!groupMatcher.getCompareWithOperator().evaluate(string, groupMatcher.getCompareToValue())) continue;
                commonsHashSet.add(string);
            }
        });
        this.m_aRWLock.writeLocked(() -> {
            for (String string : commonsHashSet) {
                this.m_aPausedJobGroups.remove(string);
            }
        });
        for (JobKey jobKey : iCommonsSet) {
            ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
            for (IOperableTrigger iOperableTrigger : iCommonsList) {
                this.resumeTrigger(iOperableTrigger.getKey());
            }
        }
        return commonsHashSet;
    }

    @Override
    public void pauseAll() {
        ICommonsList<String> iCommonsList = this.getTriggerGroupNames();
        for (String string : iCommonsList) {
            this.pauseTriggers((GroupMatcher)GroupMatcher.triggerGroupEquals(string));
        }
    }

    @Override
    public void resumeAll() {
        this.m_aRWLock.writeLocked(this.m_aPausedJobGroups::clear);
        this.resumeTriggers((GroupMatcher)GroupMatcher.anyTriggerGroup());
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected boolean applyMisfire(TriggerWrapper triggerWrapper) {
        Date date;
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if ((date = triggerWrapper.getTrigger().getNextFireTime()) == null || date.getTime() > l || triggerWrapper.getTrigger().getMisfireInstruction() == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY) {
            return false;
        }
        ICalendar iCalendar = null;
        if (triggerWrapper.getTrigger().getCalendarName() != null) {
            iCalendar = this.retrieveCalendar(triggerWrapper.getTrigger().getCalendarName());
        }
        this.m_aSignaler.notifyTriggerListenersMisfired(triggerWrapper.getTrigger().getClone());
        triggerWrapper.getTrigger().updateAfterMisfire(iCalendar);
        if (triggerWrapper.getTrigger().getNextFireTime() == null) {
            triggerWrapper.setState(3);
            this.m_aSignaler.notifySchedulerListenersFinalized(triggerWrapper.getTrigger());
            this.m_aTimeTriggers.remove(triggerWrapper);
        } else if (date.equals(triggerWrapper.getTrigger().getNextFireTime())) {
            return false;
        }
        return true;
    }

    protected String getFiredTriggerRecordId() {
        return Long.toString(s_aFiredTriggerRecordID.incrementAndGet());
    }

    @Override
    public ICommonsList<IOperableTrigger> acquireNextTriggers(long l, int n, long l2) {
        return this.m_aRWLock.writeLockedGet(() -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            CommonsHashSet commonsHashSet = new CommonsHashSet();
            CommonsHashSet commonsHashSet2 = new CommonsHashSet();
            long l3 = 0L;
            if (this.m_aTimeTriggers.isEmpty()) {
                return commonsArrayList;
            }
            while (true) {
                TriggerWrapper triggerWrapper;
                try {
                    triggerWrapper = (TriggerWrapper)this.m_aTimeTriggers.first();
                    if (triggerWrapper == null) break;
                    this.m_aTimeTriggers.remove(triggerWrapper);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (triggerWrapper.getTrigger().getNextFireTime() == null) continue;
                if (this.applyMisfire(triggerWrapper)) {
                    if (triggerWrapper.getTrigger().getNextFireTime() == null) continue;
                    this.m_aTimeTriggers.add(triggerWrapper);
                    continue;
                }
                if (triggerWrapper.getTrigger().getNextFireTime().getTime() > l + l2) {
                    this.m_aTimeTriggers.add(triggerWrapper);
                    break;
                }
                JobKey jobKey = triggerWrapper.getJobKey();
                IJobDetail iJobDetail = ((JobWrapper)this.m_aJobsByKey.get(triggerWrapper.getJobKey())).getJobDetail();
                if (iJobDetail.isConcurrentExectionDisallowed() && !commonsHashSet.add(jobKey)) {
                    commonsHashSet2.add(triggerWrapper);
                    continue;
                }
                triggerWrapper.setState(1);
                triggerWrapper.getTrigger().setFireInstanceId(this.getFiredTriggerRecordId());
                IOperableTrigger iOperableTrigger = triggerWrapper.getTrigger().getClone();
                commonsArrayList.add(iOperableTrigger);
                if (l3 == 0L) {
                    l3 = triggerWrapper.getTrigger().getNextFireTime().getTime();
                }
                if (commonsArrayList.size() == n) break;
            }
            if (!commonsHashSet2.isEmpty()) {
                this.m_aTimeTriggers.addAll(commonsHashSet2);
            }
            return commonsArrayList;
        });
    }

    @Override
    public void releaseAcquiredTrigger(IOperableTrigger iOperableTrigger) {
        this.m_aRWLock.writeLocked(() -> {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(iOperableTrigger.getKey());
            if (triggerWrapper != null && triggerWrapper.getState() == 1) {
                triggerWrapper.setState(0);
                this.m_aTimeTriggers.add(triggerWrapper);
            }
        });
    }

    @Override
    public ICommonsList<TriggerFiredResult> triggersFired(List<IOperableTrigger> list) {
        return this.m_aRWLock.writeLockedGet(() -> {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (IOperableTrigger iOperableTrigger : list) {
                TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(iOperableTrigger.getKey());
                if (triggerWrapper == null || triggerWrapper.getState() != 1) continue;
                ICalendar iCalendar = null;
                if (triggerWrapper.getTrigger().getCalendarName() != null && (iCalendar = this.retrieveCalendar(triggerWrapper.getTrigger().getCalendarName())) == null) continue;
                Date date = iOperableTrigger.getPreviousFireTime();
                this.m_aTimeTriggers.remove(triggerWrapper);
                triggerWrapper.getTrigger().triggered(iCalendar);
                iOperableTrigger.triggered(iCalendar);
                triggerWrapper.setState(0);
                TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(this.retrieveJob(triggerWrapper.getJobKey()), iOperableTrigger, iCalendar, false, new Date(), iOperableTrigger.getPreviousFireTime(), date, iOperableTrigger.getNextFireTime());
                IJobDetail iJobDetail = triggerFiredBundle.getJobDetail();
                if (iJobDetail.isConcurrentExectionDisallowed()) {
                    ICommonsList<TriggerWrapper> iCommonsList = this.getTriggerWrappersForJob(iJobDetail.getKey());
                    for (TriggerWrapper triggerWrapper2 : iCommonsList) {
                        if (triggerWrapper2.getState() == 0) {
                            triggerWrapper2.setState(5);
                        }
                        if (triggerWrapper2.getState() == 4) {
                            triggerWrapper2.setState(6);
                        }
                        this.m_aTimeTriggers.remove(triggerWrapper2);
                    }
                    this.m_aBlockedJobs.add(iJobDetail.getKey());
                } else if (triggerWrapper.getTrigger().getNextFireTime() != null) {
                    this.m_aTimeTriggers.add(triggerWrapper);
                }
                commonsArrayList.add(new TriggerFiredResult(triggerFiredBundle));
            }
            return commonsArrayList;
        });
    }

    @Override
    public void triggeredJobComplete(IOperableTrigger iOperableTrigger, IJobDetail iJobDetail, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        this.m_aRWLock.writeLocked(() -> {
            JobWrapper jobWrapper = (JobWrapper)this.m_aJobsByKey.get(iJobDetail.getKey());
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(iOperableTrigger.getKey());
            if (jobWrapper != null) {
                Serializable serializable;
                IJobDetail iJobDetail2 = jobWrapper.getJobDetail();
                if (iJobDetail2.isPersistJobDataAfterExecution()) {
                    serializable = iJobDetail.getJobDataMap();
                    if (serializable != null) {
                        serializable = ((JobDataMap)serializable).getClone();
                    }
                    iJobDetail2 = iJobDetail2.getJobBuilder().setJobData((JobDataMap)serializable).build();
                    jobWrapper.setJobDetail(iJobDetail2);
                }
                if (iJobDetail2.isConcurrentExectionDisallowed()) {
                    this.m_aBlockedJobs.remove(iJobDetail2.getKey());
                    serializable = this.getTriggerWrappersForJob(iJobDetail2.getKey());
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        TriggerWrapper triggerWrapper2 = (TriggerWrapper)iterator.next();
                        if (triggerWrapper2.getState() == 5) {
                            triggerWrapper2.setState(0);
                            this.m_aTimeTriggers.add(triggerWrapper2);
                        }
                        if (triggerWrapper2.getState() != 6) continue;
                        triggerWrapper2.setState(4);
                    }
                    this.m_aSignaler.signalSchedulingChange(0L);
                }
            } else {
                this.m_aBlockedJobs.remove(iJobDetail.getKey());
            }
            if (triggerWrapper != null) {
                if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (iOperableTrigger.getNextFireTime() == null) {
                        if (triggerWrapper.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(iOperableTrigger.getKey());
                        }
                    } else {
                        this.removeTrigger(iOperableTrigger.getKey());
                        this.m_aSignaler.signalSchedulingChange(0L);
                    }
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    triggerWrapper.setState(3);
                    this.m_aTimeTriggers.remove(triggerWrapper);
                    this.m_aSignaler.signalSchedulingChange(0L);
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    LOGGER.info("Trigger " + iOperableTrigger.getKey() + " set to ERROR state.");
                    triggerWrapper.setState(7);
                    this.m_aSignaler.signalSchedulingChange(0L);
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    LOGGER.info("All triggers of Job " + iOperableTrigger.getJobKey() + " set to ERROR state.");
                    this.setAllTriggersOfJobToState(iOperableTrigger.getJobKey(), 7);
                    this.m_aSignaler.signalSchedulingChange(0L);
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.setAllTriggersOfJobToState(iOperableTrigger.getJobKey(), 3);
                    this.m_aSignaler.signalSchedulingChange(0L);
                }
            }
        });
    }

    @MustBeLocked(value=ELockType.WRITE)
    protected void setAllTriggersOfJobToState(JobKey jobKey, int n) {
        ICommonsList<TriggerWrapper> iCommonsList = this.getTriggerWrappersForJob(jobKey);
        for (TriggerWrapper triggerWrapper : iCommonsList) {
            triggerWrapper.setState(n);
            if (n == 0) continue;
            this.m_aTimeTriggers.remove(triggerWrapper);
        }
    }

    protected String peekTriggers() {
        return this.m_aRWLock.readLockedGet(() -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (TriggerWrapper triggerWrapper : this.m_aTriggersByKey.values()) {
                stringBuilder.append(triggerWrapper.getTriggerKey().getName());
                stringBuilder.append("/");
            }
            stringBuilder.append(" | ");
            for (TriggerWrapper triggerWrapper : this.m_aTimeTriggers) {
                stringBuilder.append(triggerWrapper.getTriggerKey().getName());
                stringBuilder.append("->");
            }
            return stringBuilder.toString();
        });
    }

    @Override
    public ICommonsSet<String> getPausedTriggerGroups() throws JobPersistenceException {
        return this.m_aRWLock.readLockedGet(this.m_aPausedTriggerGroups::getClone);
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 5L;
    }

    @Override
    public boolean isClustered() {
        return false;
    }
}

