/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.jobstore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.JobKey;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
final class JobWrapper {
    private final JobKey m_aKey;
    private IJobDetail m_aJobDetail;

    JobWrapper(@Nonnull IJobDetail iJobDetail) {
        this.m_aKey = iJobDetail.getKey();
        this.setJobDetail(iJobDetail);
    }

    @Nonnull
    public JobKey getJobKey() {
        return this.m_aKey;
    }

    @Nonnull
    public IJobDetail getJobDetail() {
        return this.m_aJobDetail;
    }

    public void setJobDetail(@Nonnull IJobDetail iJobDetail) {
        ValueEnforcer.notNull(iJobDetail, "JobDetail");
        ValueEnforcer.isTrue(iJobDetail.getKey().equals(this.m_aKey), "Different JobKey!");
        this.m_aJobDetail = iJobDetail;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        JobWrapper jobWrapper = (JobWrapper)object;
        return this.m_aKey.equals(jobWrapper.m_aKey);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aKey).getHashCode();
    }
}

