/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.jobstore;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.quartz.JobKey;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IOperableTrigger;
import javax.annotation.Nonnull;

final class TriggerWrapper {
    public static final int STATE_WAITING = 0;
    public static final int STATE_ACQUIRED = 1;
    public static final int STATE_EXECUTING = 2;
    public static final int STATE_COMPLETE = 3;
    public static final int STATE_PAUSED = 4;
    public static final int STATE_BLOCKED = 5;
    public static final int STATE_PAUSED_BLOCKED = 6;
    public static final int STATE_ERROR = 7;
    private final IOperableTrigger m_aTrigger;
    private final TriggerKey m_aTriggerKey;
    private final JobKey m_aJobKey;
    private int m_nState = 0;

    TriggerWrapper(@Nonnull IOperableTrigger iOperableTrigger) {
        ValueEnforcer.notNull(iOperableTrigger, "Trigger");
        this.m_aTrigger = iOperableTrigger;
        this.m_aTriggerKey = iOperableTrigger.getKey();
        this.m_aJobKey = iOperableTrigger.getJobKey();
    }

    @Nonnull
    public IOperableTrigger getTrigger() {
        return this.m_aTrigger;
    }

    @Nonnull
    public TriggerKey getTriggerKey() {
        return this.m_aTriggerKey;
    }

    @Nonnull
    public JobKey getJobKey() {
        return this.m_aJobKey;
    }

    public int getState() {
        return this.m_nState;
    }

    public void setState(int n) {
        this.m_nState = n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TriggerWrapper triggerWrapper = (TriggerWrapper)object;
        return this.m_aTriggerKey.equals(triggerWrapper.m_aTriggerKey);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aTriggerKey).getHashCode();
    }
}

