/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.quartz.listener;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import javax.annotation.Nonnull;

public class StatisticsJobListener
implements IJobListener {
    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return "StatisticsJobListener";
    }

    @Nonnull
    @Nonempty
    protected String getStatisticsName(@Nonnull IJobExecutionContext iJobExecutionContext) {
        return "quartz." + ClassHelper.getClassLocalName(iJobExecutionContext.getJobDetail().getJobClass());
    }

    @Override
    public void jobToBeExecuted(@Nonnull IJobExecutionContext iJobExecutionContext) {
    }

    @Override
    public void jobExecutionVetoed(@Nonnull IJobExecutionContext iJobExecutionContext) {
        StatisticsManager.getCounterHandler(this.getStatisticsName(iJobExecutionContext) + "$VETOED").increment();
    }

    @Override
    public void jobWasExecuted(@Nonnull IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        StatisticsManager.getCounterHandler(this.getStatisticsName(iJobExecutionContext) + "$EXEC").increment();
        if (jobExecutionException != null) {
            StatisticsManager.getCounterHandler(this.getStatisticsName(iJobExecutionContext) + "$ERROR").increment();
        }
    }
}

