/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.commons.ValueEnforcer;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SchematronDebug {
    private static final AtomicBoolean s_bSaveIntermediateXSLTFiles = new AtomicBoolean(false);
    private static File s_aIntermediateMinifiedSCHFolder = new File("test-minified");
    private static File s_aIntermediateFinalXSLTFolder = new File("test-final");
    private static final AtomicBoolean s_aShowCreatedXSLT = new AtomicBoolean(false);
    private static final AtomicBoolean s_aShowCreatedSVRL = new AtomicBoolean(false);
    private static final AtomicBoolean s_aShowPreprocessedSchematron = new AtomicBoolean(false);
    private static final AtomicBoolean s_aShowResolvedSourceSchematron = new AtomicBoolean(false);

    private SchematronDebug() {
    }

    public static void setDebugMode(boolean bl) {
        SchematronDebug.setSaveIntermediateXSLTFiles(bl);
        SchematronDebug.setShowCreatedXSLT(bl);
        SchematronDebug.setShowCreatedSVRL(bl);
        SchematronDebug.setShowResolvedSourceSchematron(bl);
        SchematronDebug.setShowPreprocessedSchematron(bl);
    }

    public static boolean isSaveIntermediateXSLTFiles() {
        return s_bSaveIntermediateXSLTFiles.get();
    }

    public static void setSaveIntermediateXSLTFiles(boolean bl) {
        s_bSaveIntermediateXSLTFiles.set(bl);
    }

    @Nonnull
    public static File getIntermediateMinifiedSCHFolder() {
        return s_aIntermediateMinifiedSCHFolder;
    }

    public static void setIntermediateMinifiedSCHFolder(@Nonnull File file) {
        ValueEnforcer.notNull(file, "IntermediateMinifiedSCHFolder");
        s_aIntermediateMinifiedSCHFolder = file;
    }

    @Nonnull
    public static File getIntermediateFinalXSLTFolder() {
        return s_aIntermediateFinalXSLTFolder;
    }

    public static void setIntermediateFinalXSLTFolder(@Nonnull File file) {
        ValueEnforcer.notNull(file, "IntermediateFinalXSLTFolder");
        s_aIntermediateFinalXSLTFolder = file;
    }

    public static void setShowCreatedXSLT(boolean bl) {
        s_aShowCreatedXSLT.set(bl);
    }

    public static boolean isShowCreatedXSLT() {
        return s_aShowCreatedXSLT.get();
    }

    public static void setShowCreatedSVRL(boolean bl) {
        s_aShowCreatedSVRL.set(bl);
    }

    public static boolean isShowCreatedSVRL() {
        return s_aShowCreatedSVRL.get();
    }

    public static void setShowResolvedSourceSchematron(boolean bl) {
        s_aShowResolvedSourceSchematron.set(bl);
    }

    public static boolean isShowResolvedSourceSchematron() {
        return s_aShowResolvedSourceSchematron.get();
    }

    public static void setShowPreprocessedSchematron(boolean bl) {
        s_aShowPreprocessedSchematron.set(bl);
    }

    public static boolean isShowPreprocessedSchematron() {
        return s_aShowPreprocessedSchematron.get();
    }
}

