/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.binding;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.exception.InitializationException;
import com.helger.schematron.pure.binding.IPSQueryBinding;
import com.helger.schematron.pure.binding.SchematronBindException;
import com.helger.schematron.pure.binding.xpath.PSXPathQueryBinding;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class PSQueryBindingRegistry {
    public static final String QUERY_BINDING_XSLT = "xslt";
    public static final String QUERY_BINDING_XSLT2 = "xslt2";
    public static final String QUERY_BINDING_XPATH = "xpath";
    public static final String QUERY_BINDING_XPATH2 = "xpath2";
    public static final IPSQueryBinding DEFAULT_QUERY_BINDING = PSXPathQueryBinding.getInstance();
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final ICommonsMap<String, IPSQueryBinding> s_aMap = new CommonsHashMap<String, IPSQueryBinding>();
    private static final PSQueryBindingRegistry s_aInstance;

    private PSQueryBindingRegistry() {
    }

    public static void registerQueryBinding(@Nonnull @Nonempty String string, @Nonnull IPSQueryBinding iPSQueryBinding) throws SchematronBindException {
        ValueEnforcer.notEmpty(string, "Name");
        ValueEnforcer.notNull(iPSQueryBinding, "QueryBinding");
        s_aRWLock.writeLockedThrowing(() -> {
            if (s_aMap.containsKey(string)) {
                throw new SchematronBindException("A queryBinding with the name '" + string + "' is already registered!");
            }
            s_aMap.put(string, iPSQueryBinding);
        });
    }

    @Nullable
    public static IPSQueryBinding getQueryBindingOfName(@Nullable String string) {
        if (string == null) {
            return DEFAULT_QUERY_BINDING;
        }
        return s_aRWLock.readLockedGet(() -> (IPSQueryBinding)s_aMap.get(string));
    }

    @Nonnull
    public static IPSQueryBinding getQueryBindingOfNameOrThrow(@Nullable String string) throws SchematronBindException {
        IPSQueryBinding iPSQueryBinding = PSQueryBindingRegistry.getQueryBindingOfName(string);
        if (iPSQueryBinding == null) {
            throw new SchematronBindException("No query binding implementation present for query binding '" + string + "'");
        }
        return iPSQueryBinding;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, IPSQueryBinding> getAllRegisteredQueryBindings() {
        return s_aRWLock.readLockedGet(s_aMap::getClone);
    }

    static {
        try {
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XSLT2, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XPATH, DEFAULT_QUERY_BINDING);
            PSQueryBindingRegistry.registerQueryBinding(QUERY_BINDING_XPATH2, DEFAULT_QUERY_BINDING);
        }
        catch (SchematronBindException schematronBindException) {
            throw new InitializationException(schematronBindException);
        }
        s_aInstance = new PSQueryBindingRegistry();
    }
}

