/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.bound.xpath;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.schematron.pure.bound.xpath.PSXPathBoundElement;
import com.helger.schematron.pure.model.PSDiagnostic;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PSXPathBoundDiagnostic {
    private final PSDiagnostic m_aDiagnostic;
    private final ICommonsList<PSXPathBoundElement> m_aBoundContent;

    public PSXPathBoundDiagnostic(@Nonnull PSDiagnostic pSDiagnostic, @Nonnull ICommonsList<PSXPathBoundElement> iCommonsList) {
        ValueEnforcer.notNull(pSDiagnostic, "Diagnostic");
        ValueEnforcer.notNull(iCommonsList, "BoundContent");
        this.m_aDiagnostic = pSDiagnostic;
        this.m_aBoundContent = iCommonsList;
    }

    @Nonnull
    public PSDiagnostic getDiagnostic() {
        return this.m_aDiagnostic;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<PSXPathBoundElement> getAllBoundContentElements() {
        return (ICommonsList)this.m_aBoundContent.getClone();
    }

    public String toString() {
        return new ToStringGenerator(this).append("diagnostic", this.m_aDiagnostic).append("boundContent", this.m_aBoundContent).getToString();
    }
}

