/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.pure.errorhandler;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.ErrorTextProvider;
import com.helger.commons.error.IError;
import com.helger.commons.error.IErrorTextProvider;
import com.helger.commons.log.LogHelper;
import com.helger.schematron.pure.errorhandler.AbstractPSErrorHandler;
import com.helger.schematron.pure.errorhandler.IPSErrorHandler;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingPSErrorHandler
extends AbstractPSErrorHandler {
    public static final IErrorTextProvider DEFAULT_PS = new ErrorTextProvider().addItem(ErrorTextProvider.EField.ERROR_LEVEL, "[$]").addItem(ErrorTextProvider.EField.ERROR_ID, "[$]").addItem(ErrorTextProvider.EField.ERROR_FIELD_NAME, "[$]").addItem(ErrorTextProvider.EField.ERROR_LOCATION, "@ $").addItem(ErrorTextProvider.EField.ERROR_TEXT, "$").addItem(ErrorTextProvider.EField.ERROR_LINKED_EXCEPTION_CLASS, "($:").addItem(ErrorTextProvider.EField.ERROR_LINKED_EXCEPTION_MESSAGE, "$)").setFieldSeparator(" ");
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingPSErrorHandler.class);
    private IErrorTextProvider m_aETP = DEFAULT_PS;

    public LoggingPSErrorHandler() {
    }

    public LoggingPSErrorHandler(@Nullable IPSErrorHandler iPSErrorHandler) {
        super(iPSErrorHandler);
    }

    @Nonnull
    public final IErrorTextProvider getErrorTextProvider() {
        return this.m_aETP;
    }

    @Nonnull
    public final LoggingPSErrorHandler setErrorTextProvider(@Nonnull IErrorTextProvider iErrorTextProvider) {
        ValueEnforcer.notNull(iErrorTextProvider, "ErrorTextProvider");
        this.m_aETP = iErrorTextProvider;
        return this;
    }

    @Override
    protected void handleInternally(@Nonnull IError iError) {
        LogHelper.log(LOGGER, iError.getErrorLevel(), this.m_aETP.getErrorText(iError, Locale.US), iError.getLinkedException());
    }
}

