/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.saxon;

import com.helger.commons.CGlobal;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.lang.ClassLoaderHelper;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.LoggingTransformErrorListener;
import java.net.URL;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SchematronTransformerFactory {
    public static final String SAXON_TRANSFORMER_FACTORY_CLASS = "net.sf.saxon.TransformerFactoryImpl";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchematronTransformerFactory.class);
    private static final TransformerFactory s_aDefaultFactory = SchematronTransformerFactory.createTransformerFactorySaxonFirst(SchematronTransformerFactory.class.getClassLoader(), new LoggingTransformErrorListener(CGlobal.DEFAULT_LOCALE), new DefaultTransformURIResolver());

    private SchematronTransformerFactory() {
    }

    @Nonnull
    public static TransformerFactory getDefaultSaxonFirst() {
        return s_aDefaultFactory;
    }

    @Nonnull
    public static TransformerFactory createTransformerFactorySaxonFirst(@Nullable ClassLoader classLoader, @Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        TransformerFactory transformerFactory;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Calling createTransformerFactorySaxonFirst");
        }
        ClassLoader classLoader2 = classLoader != null ? classLoader : ClassLoaderHelper.getContextClassLoader();
        try {
            transformerFactory = TransformerFactory.newInstance(SAXON_TRANSFORMER_FACTORY_CLASS, classLoader2);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Created TransformerFactory with Saxon using 'net.sf.saxon.TransformerFactoryImpl'");
            }
        }
        catch (TransformerConfigurationException | TransformerFactoryConfigurationError throwable) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to create TransformerFactory with Saxon.", throwable);
                try {
                    LOGGER.debug("Done checking implementations using classloader " + classLoader2);
                    Enumeration<URL> enumeration = classLoader2.getResources("META-INF/services/javax.xml.transform.TransformerFactory");
                    while (enumeration.hasMoreElements()) {
                        LOGGER.debug("  " + enumeration.nextElement().toExternalForm());
                    }
                    LOGGER.debug("Done checking implementations");
                }
                catch (Exception exception) {
                    LOGGER.error("Error determining implementations", exception);
                }
            }
            try {
                transformerFactory = TransformerFactory.newInstance();
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                throw new InitializationException("Failed to create XML TransformerFactory", transformerFactoryConfigurationError);
            }
        }
        if (errorListener != null) {
            transformerFactory.setErrorListener(errorListener);
        }
        if (uRIResolver != null) {
            transformerFactory.setURIResolver(uRIResolver);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Created TransformerFactory is " + transformerFactory);
        }
        return transformerFactory;
    }
}

