/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.security.authentication.credentials.IAuthCredentialToSubjectResolverSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.subject.IAuthSubject;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AuthCredentialToSubjectResolverManager {
    private static final ICommonsList<IAuthCredentialToSubjectResolverSPI> s_aHdlList = ServiceLoaderHelper.getAllSPIImplementations(IAuthCredentialToSubjectResolverSPI.class);

    private AuthCredentialToSubjectResolverManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAuthCredentialToSubjectResolverSPI> getAllAuthCredentialToSubjectResolvers() {
        return (ICommonsList)s_aHdlList.getClone();
    }

    @Nonnegative
    public static int getAuthCredentialToSubjectResolverCount() {
        return s_aHdlList.size();
    }

    @Nullable
    public static IAuthSubject getSubjectFromCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        for (IAuthCredentialToSubjectResolverSPI iAuthCredentialToSubjectResolverSPI : s_aHdlList) {
            IAuthSubject iAuthSubject;
            if (!iAuthCredentialToSubjectResolverSPI.supportsCredentials(iAuthCredentials) || (iAuthSubject = iAuthCredentialToSubjectResolverSPI.getSubjectFromCredentials(iAuthCredentials)) == null) continue;
            return iAuthSubject;
        }
        return null;
    }
}

