/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.result;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.authentication.credentials.ICredentialValidationResult;
import com.helger.security.authentication.result.IAuthToken;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AuthIdentificationResult
implements ISuccessIndicator,
Serializable {
    private final IAuthToken m_aAuthToken;
    private final ICredentialValidationResult m_aCredentialValidationFailure;

    protected AuthIdentificationResult(@Nullable IAuthToken iAuthToken, @Nullable ICredentialValidationResult iCredentialValidationResult) {
        ValueEnforcer.isFalse(iAuthToken == null && iCredentialValidationResult == null, "One parameter must be set");
        ValueEnforcer.isFalse(iAuthToken != null && iCredentialValidationResult != null, "Only one parameter may be set");
        if (iCredentialValidationResult != null && iCredentialValidationResult.isSuccess()) {
            throw new IllegalStateException("Don't call this method for successfuly credential validation!");
        }
        this.m_aAuthToken = iAuthToken;
        this.m_aCredentialValidationFailure = iCredentialValidationResult;
    }

    @Override
    public boolean isSuccess() {
        return this.m_aAuthToken != null;
    }

    @Override
    public boolean isFailure() {
        return this.m_aCredentialValidationFailure != null;
    }

    @Nullable
    public IAuthToken getAuthToken() {
        return this.m_aAuthToken;
    }

    @Nullable
    public ICredentialValidationResult getCredentialValidationFailure() {
        return this.m_aCredentialValidationFailure;
    }

    public String toString() {
        return new ToStringGenerator(this).append("AuthToken", this.m_aAuthToken).append("CredentialValidationFailure", this.m_aCredentialValidationFailure).getToString();
    }

    @Nonnull
    public static AuthIdentificationResult createSuccess(@Nonnull IAuthToken iAuthToken) {
        ValueEnforcer.notNull(iAuthToken, "AuthToken");
        return new AuthIdentificationResult(iAuthToken, null);
    }

    @Nonnull
    public static AuthIdentificationResult createFailure(@Nonnull ICredentialValidationResult iCredentialValidationResult) {
        ValueEnforcer.notNull(iCredentialValidationResult, "CredentialValidationFailure");
        return new AuthIdentificationResult(null, iCredentialValidationResult);
    }
}

