/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.hash;

import com.helger.commons.ValueEnforcer;
import com.helger.security.messagedigest.EMessageDigestAlgorithm;
import com.helger.security.messagedigest.MessageDigestValue;
import com.helger.security.password.hash.AbstractPasswordHashCreator;
import com.helger.security.password.salt.IPasswordSalt;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PasswordHashCreatorSHA512
extends AbstractPasswordHashCreator {
    public static final String ALGORITHM = "default";
    public static final EMessageDigestAlgorithm USER_PASSWORD_ALGO = EMessageDigestAlgorithm.SHA_512;

    public PasswordHashCreatorSHA512() {
        super(ALGORITHM);
    }

    @Override
    public boolean requiresSalt() {
        return false;
    }

    @Override
    @Nonnull
    public String createPasswordHash(@Nullable IPasswordSalt iPasswordSalt, @Nonnull String string) {
        ValueEnforcer.notNull(string, "PlainTextPassword");
        return MessageDigestValue.create(string.getBytes(StandardCharsets.UTF_8), USER_PASSWORD_ALGO).getHexEncodedDigestString();
    }
}

