/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.salt;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.security.password.salt.IPasswordSalt;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Nonnegative
@Immutable
public final class PasswordSalt
implements IPasswordSalt {
    public static final int DEFAULT_SALT_BYTES = 512;
    private final byte[] m_aBytes;
    private final String m_sSalt;

    public PasswordSalt() {
        this(512);
    }

    public PasswordSalt(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "SaltBytes");
        this.m_aBytes = new byte[n];
        new Random().nextBytes(this.m_aBytes);
        this.m_sSalt = StringHelper.getHexEncoded(this.m_aBytes);
    }

    private PasswordSalt(@Nonnull @Nonempty byte[] byArray) {
        ValueEnforcer.notEmpty(byArray, "Bytes");
        this.m_aBytes = byArray;
        this.m_sSalt = StringHelper.getHexEncoded(byArray);
    }

    @Override
    @Nonnegative
    public int getSaltByteCount() {
        return this.m_aBytes.length;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getSaltBytes() {
        return ArrayHelper.getCopy(this.m_aBytes);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSaltString() {
        return this.m_sSalt;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordSalt passwordSalt = (PasswordSalt)object;
        return Arrays.equals(this.m_aBytes, passwordSalt.m_aBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("bytes#", this.m_aBytes.length).getToString();
    }

    @Nullable
    public static PasswordSalt createFromStringMaybe(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        byte[] byArray = StringHelper.getHexDecoded(string);
        return new PasswordSalt(byArray);
    }
}

