/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import java.util.EventListener;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MockEventListenerList {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockEventListenerList.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<EventListener> m_aListener = new CommonsArrayList<EventListener>();

    @Nonnull
    public EChange setFrom(@Nonnull MockEventListenerList mockEventListenerList) {
        ValueEnforcer.notNull(mockEventListenerList, "List");
        if (this == mockEventListenerList) {
            return EChange.UNCHANGED;
        }
        ICommonsList<EventListener> iCommonsList = mockEventListenerList.getAllListeners();
        return this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aListener.isEmpty() && iCommonsList.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aListener.setAll((Iterable<EventListener>)iCommonsList);
            return EChange.CHANGED;
        });
    }

    @Nonnull
    public EChange addListener(@Nonnull EventListener eventListener) {
        ValueEnforcer.notNull(eventListener, "Listener");
        if (!(eventListener instanceof ServletContextListener || eventListener instanceof HttpSessionListener || eventListener instanceof ServletRequestListener)) {
            LOGGER.warn("Passed mock listener is none of ServletContextListener, HttpSessionListener or ServletRequestListener and therefore has no effect. The listener class is: " + eventListener.getClass());
        }
        return EChange.valueOf(this.m_aRWLock.writeLockedBoolean(() -> this.m_aListener.add(eventListener)));
    }

    @Nonnull
    public EChange removeListeners(@Nullable Class<? extends EventListener> clazz) {
        if (clazz == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLockedGet(() -> {
            EChange eChange = EChange.UNCHANGED;
            for (EventListener eventListener : (ICommonsList)this.m_aListener.getClone()) {
                if (!eventListener.getClass().equals(clazz)) continue;
                eChange = eChange.or(EChange.valueOf(this.m_aListener.remove(eventListener)));
            }
            return eChange;
        });
    }

    @Nonnull
    public EChange removeAllListeners() {
        return this.m_aRWLock.writeLockedGet(this.m_aListener::removeAll);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<EventListener> getAllListeners() {
        return this.m_aRWLock.readLockedGet(this.m_aListener::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ServletContextListener> getAllServletContextListeners() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aListener.getAllInstanceOf(ServletContextListener.class));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<HttpSessionListener> getAllHttpSessionListeners() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aListener.getAllInstanceOf(HttpSessionListener.class));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ServletRequestListener> getAllServletRequestListeners() {
        return this.m_aRWLock.readLockedGet(() -> this.m_aListener.getAllInstanceOf(ServletRequestListener.class));
    }

    public String toString() {
        return new ToStringGenerator(this).append("Listeners", this.m_aListener).getToString();
    }
}

