/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.collection.multimap.MultiHashMapLinkedHashSetBased;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeHelper;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.mime.MimeTypeParserException;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemHelper;
import com.helger.network.port.SchemeDefaultPortMapper;
import com.helger.servlet.io.AbstractServletOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockHttpServletResponse
implements HttpServletResponse {
    public static final int DEFAULT_SERVER_PORT = SchemeDefaultPortMapper.getDefaultPortOrThrow("http");
    public static final Charset DEFAULT_CHARSET_OBJ = StandardCharsets.UTF_8;
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(MockHttpServletResponse.class);
    private boolean m_bOutputStreamAccessAllowed = true;
    private boolean m_bWriterAccessAllowed = true;
    private Charset m_aCharacterEncoding = DEFAULT_CHARSET_OBJ;
    private final NonBlockingByteArrayOutputStream m_aContent = new NonBlockingByteArrayOutputStream();
    private final ServletOutputStream m_aOS = new AbstractServletOutputStream(){

        @Override
        public void write(int n) throws IOException {
            MockHttpServletResponse.this.m_aContent.write(n);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    };
    private PrintWriter m_aWriter;
    private long m_nContentLength = 0L;
    private String m_sContentType;
    private int m_nBufferSize = 4096;
    private boolean m_bCommitted;
    private Locale m_aLocale = Locale.getDefault();
    private final ICommonsList<Cookie> m_aCookies = new CommonsArrayList<Cookie>();
    private final MultiHashMapLinkedHashSetBased<String, String> m_aHeaders = new MultiHashMapLinkedHashSetBased();
    private int m_nStatus = 200;
    private String m_sErrorMessage;
    private String m_sRedirectedUrl;
    private String m_sForwardedUrl;
    private String m_sIncludedUrl;
    private String m_sEncodeUrlSuffix;
    private String m_sEncodeRedirectUrlSuffix;

    public void setOutputStreamAccessAllowed(boolean bl) {
        this.m_bOutputStreamAccessAllowed = bl;
    }

    public boolean isOutputStreamAccessAllowed() {
        return this.m_bOutputStreamAccessAllowed;
    }

    public void setWriterAccessAllowed(boolean bl) {
        this.m_bWriterAccessAllowed = bl;
    }

    public boolean isWriterAccessAllowed() {
        return this.m_bWriterAccessAllowed;
    }

    @Override
    public void setCharacterEncoding(@Nullable String string) {
        this.setCharacterEncoding(CharsetHelper.getCharsetFromNameOrNull(string));
    }

    public void setCharacterEncoding(@Nullable Charset charset) {
        this.m_aCharacterEncoding = charset;
    }

    @Override
    @Nullable
    public String getCharacterEncoding() {
        return this.m_aCharacterEncoding == null ? null : this.m_aCharacterEncoding.name();
    }

    @Nullable
    public Charset getCharacterEncodingObj() {
        return this.m_aCharacterEncoding;
    }

    @Nonnull
    public Charset getCharacterEncodingObjOrDefault() {
        Charset charset = this.getCharacterEncodingObj();
        if (charset == null) {
            charset = SystemHelper.getSystemCharset();
        }
        return charset;
    }

    @Override
    @Nonnull
    public ServletOutputStream getOutputStream() {
        if (!this.m_bOutputStreamAccessAllowed) {
            throw new IllegalStateException("OutputStream access not allowed");
        }
        return this.m_aOS;
    }

    @Override
    @Nonnull
    public PrintWriter getWriter() {
        if (!this.m_bWriterAccessAllowed) {
            throw new IllegalStateException("Writer access not allowed");
        }
        if (this.m_aWriter == null) {
            OutputStreamWriter outputStreamWriter = StreamHelper.createWriter(this.m_aContent, this.getCharacterEncodingObjOrDefault());
            this.m_aWriter = new ResponsePrintWriter(outputStreamWriter);
        }
        return this.m_aWriter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getContentAsByteArray() {
        this.flushBuffer();
        return this.m_aContent.toByteArray();
    }

    @Nonnull
    public String getContentAsString(@Nonnull Charset charset) {
        this.flushBuffer();
        return this.m_aContent.getAsString(charset);
    }

    @Override
    public void setContentLength(int n) {
        this.m_nContentLength = n;
    }

    public int getContentLength() {
        return (int)this.m_nContentLength;
    }

    @Override
    public void setContentType(@Nullable String string) {
        this.m_sContentType = string;
        if (string != null) {
            try {
                MimeType mimeType = MimeTypeParser.parseMimeType(string);
                String string2 = MimeTypeHelper.getCharsetNameFromMimeType(mimeType);
                if (string2 != null) {
                    this.setCharacterEncoding(string2);
                }
            }
            catch (MimeTypeParserException mimeTypeParserException) {
                LOGGER.warn("Passed content type '" + string + "' cannot be parsed as a MIME type");
            }
        }
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    @Override
    public void setBufferSize(int n) {
        this.m_nBufferSize = n;
    }

    @Override
    public int getBufferSize() {
        return this.m_nBufferSize;
    }

    @Override
    public void flushBuffer() {
        this.setCommitted(true);
    }

    @Override
    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset buffer - response is already committed");
        }
        this.m_aContent.reset();
        this.m_aWriter = null;
    }

    private void _setCommittedIfBufferSizeExceeded() {
        int n = this.getBufferSize();
        if (n > 0 && this.m_aContent.size() > n) {
            this.setCommitted(true);
        }
    }

    public void setCommitted(boolean bl) {
        this.m_bCommitted = bl;
    }

    @Override
    public boolean isCommitted() {
        return this.m_bCommitted;
    }

    @Override
    public void reset() {
        this.resetBuffer();
        this.m_aCharacterEncoding = null;
        this.m_nContentLength = 0L;
        this.m_sContentType = null;
        this.m_aLocale = null;
        this.m_aCookies.clear();
        this.m_aHeaders.clear();
        this.m_nStatus = 200;
        this.m_sErrorMessage = null;
    }

    @Override
    public void setLocale(@Nullable Locale locale) {
        this.m_aLocale = locale;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return this.m_aLocale;
    }

    @Override
    public void addCookie(@Nonnull Cookie cookie) {
        ValueEnforcer.notNull(cookie, "Cookie");
        this.m_aCookies.add(cookie);
    }

    @Nonnull
    @ReturnsMutableCopy
    public Cookie[] getCookies() {
        return ArrayHelper.newArray(this.m_aCookies, Cookie.class);
    }

    @Nullable
    public Cookie getCookie(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        for (Cookie cookie : this.m_aCookies) {
            if (!string.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    @Nullable
    private static String _unifyHeaderName(@Nullable String string) {
        return string == null ? null : string.toLowerCase(Locale.US);
    }

    @Override
    public boolean containsHeader(@Nullable String string) {
        return this.m_aHeaders.containsKey(MockHttpServletResponse._unifyHeaderName(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getHeaderNames() {
        return this.m_aHeaders.copyOfKeySet();
    }

    @Override
    @Nullable
    public String getHeader(@Nullable String string) {
        ICommonsOrderedSet iCommonsOrderedSet = (ICommonsOrderedSet)this.m_aHeaders.get(MockHttpServletResponse._unifyHeaderName(string));
        return iCommonsOrderedSet == null ? null : (String)iCommonsOrderedSet.getFirst();
    }

    @Nonnull
    public ICommonsList<String> getHeaders(@Nullable String string) {
        return new CommonsArrayList<Collection>((Collection)this.m_aHeaders.get(MockHttpServletResponse._unifyHeaderName(string)));
    }

    @Override
    @Nullable
    public String encodeURL(@Nullable String string) {
        if (StringHelper.hasText(this.m_sEncodeUrlSuffix)) {
            return StringHelper.getNotNull(string) + this.m_sEncodeUrlSuffix;
        }
        return string;
    }

    @Override
    @Nullable
    public String encodeRedirectURL(@Nullable String string) {
        if (StringHelper.hasText(this.m_sEncodeRedirectUrlSuffix)) {
            return StringHelper.getNotNull(string) + this.m_sEncodeRedirectUrlSuffix;
        }
        return string;
    }

    @Override
    @Deprecated
    public String encodeUrl(@Nullable String string) {
        return this.encodeURL(string);
    }

    @Override
    @Deprecated
    public String encodeRedirectUrl(@Nullable String string) {
        return this.encodeRedirectURL(string);
    }

    @Override
    public void sendError(int n, @Nullable String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.m_nStatus = n;
        this.m_sErrorMessage = string;
        this.setCommitted(true);
    }

    @Override
    public void sendError(int n) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot set error status - response is already committed");
        }
        this.m_nStatus = n;
        this.setCommitted(true);
    }

    @Override
    public void sendRedirect(@Nonnull String string) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot send redirect - response is already committed");
        }
        ValueEnforcer.notNull(string, "URL");
        this.m_sRedirectedUrl = string;
        this.setCommitted(true);
    }

    @Nullable
    public String getRedirectedUrl() {
        return this.m_sRedirectedUrl;
    }

    @Override
    public void setDateHeader(@Nullable String string, long l) {
        this._setHeaderValue(string, Long.toString(l));
    }

    @Override
    public void addDateHeader(@Nullable String string, long l) {
        this._addHeaderValue(string, Long.toString(l));
    }

    @Override
    public void setHeader(@Nullable String string, @Nullable String string2) {
        this._setHeaderValue(string, string2);
    }

    @Override
    public void addHeader(@Nullable String string, @Nullable String string2) {
        this._addHeaderValue(string, string2);
    }

    @Override
    public void setIntHeader(@Nullable String string, int n) {
        this._setHeaderValue(string, Integer.toString(n));
    }

    @Override
    public void addIntHeader(@Nullable String string, int n) {
        this._addHeaderValue(string, Integer.toString(n));
    }

    private void _setHeaderValue(@Nullable String string, @Nullable String string2) {
        this._doAddHeaderValue(string, string2, true);
    }

    private void _addHeaderValue(@Nullable String string, @Nullable String string2) {
        this._doAddHeaderValue(string, string2, false);
    }

    private void _doAddHeaderValue(@Nullable String string, @Nullable String string2, boolean bl) {
        if (bl || !this.m_aHeaders.containsSingle(MockHttpServletResponse._unifyHeaderName(string), string2)) {
            this.m_aHeaders.putSingle(MockHttpServletResponse._unifyHeaderName(string), string2);
        }
    }

    @Override
    public void setStatus(int n) {
        this.m_nStatus = n;
    }

    @Override
    @Deprecated
    public void setStatus(int n, @Nullable String string) {
        this.m_nStatus = n;
        this.m_sErrorMessage = string;
    }

    @Override
    public int getStatus() {
        return this.m_nStatus;
    }

    @Nullable
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public void setForwardedUrl(@Nullable String string) {
        this.m_sForwardedUrl = string;
    }

    @Nullable
    public String getForwardedUrl() {
        return this.m_sForwardedUrl;
    }

    public void setIncludedUrl(@Nullable String string) {
        this.m_sIncludedUrl = string;
    }

    @Nullable
    public String getIncludedUrl() {
        return this.m_sIncludedUrl;
    }

    public void setEncodeUrlSuffix(@Nullable String string) {
        this.m_sEncodeUrlSuffix = string;
    }

    @Nullable
    public String getEncodeUrlSuffix() {
        return this.m_sEncodeUrlSuffix;
    }

    public void setEncodeRedirectUrlSuffix(@Nullable String string) {
        this.m_sEncodeRedirectUrlSuffix = string;
    }

    @Nullable
    public String getEncodeRedirectUrlSuffix() {
        return this.m_sEncodeRedirectUrlSuffix;
    }

    @Override
    public void setContentLengthLong(long l) {
        this.m_nContentLength = l;
    }

    private class ResponsePrintWriter
    extends PrintWriter {
        public ResponsePrintWriter(Writer writer) {
            super(writer, true);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            super.write(cArray, n, n2);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void write(String string, int n, int n2) {
            super.write(string, n, n2);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void write(int n) {
            super.write(n);
            super.flush();
            MockHttpServletResponse.this._setCommittedIfBufferSizeExceeded();
        }

        @Override
        public void flush() {
            super.flush();
            MockHttpServletResponse.this.setCommitted(true);
        }
    }
}

