/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.servlet.mock.MockHttpServletResponse;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MockRequestDispatcher
implements RequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MockRequestDispatcher.class);
    private final String m_sURL;

    public MockRequestDispatcher(@Nonnull String string) {
        this.m_sURL = ValueEnforcer.notNull(string, "URL");
    }

    @Override
    public void forward(@Nonnull ServletRequest servletRequest, @Nonnull ServletResponse servletResponse) {
        ValueEnforcer.notNull(servletRequest, "Request");
        ValueEnforcer.notNull(servletResponse, "Response");
        if (servletResponse.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        this.getMockHttpServletResponse(servletResponse).setForwardedUrl(this.m_sURL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MockRequestDispatcher: forwarding to URL '" + this.m_sURL + "'");
        }
    }

    @Override
    public void include(@Nonnull ServletRequest servletRequest, @Nonnull ServletResponse servletResponse) {
        ValueEnforcer.notNull(servletRequest, "Request");
        ValueEnforcer.notNull(servletResponse, "Response");
        this.getMockHttpServletResponse(servletResponse).setIncludedUrl(this.m_sURL);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("MockRequestDispatcher: including URL '" + this.m_sURL + "'");
        }
    }

    @Nonnull
    protected MockHttpServletResponse getMockHttpServletResponse(@Nonnull ServletResponse servletResponse) {
        if (servletResponse instanceof MockHttpServletResponse) {
            return (MockHttpServletResponse)servletResponse;
        }
        if (servletResponse instanceof HttpServletResponseWrapper) {
            return this.getMockHttpServletResponse(((HttpServletResponseWrapper)servletResponse).getResponse());
        }
        throw new IllegalArgumentException("MockRequestDispatcher requires MockHttpServletResponse");
    }
}

