/*
 * Decompiled with CFR 0.152.
 */
package com.helger.servlet.response.gzip;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.servlet.response.gzip.AbstractCompressedResponseWrapper;
import com.helger.servlet.response.gzip.AbstractCompressedServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class GZIPResponse
extends AbstractCompressedResponseWrapper {
    private static final IMutableStatisticsHandlerCounter s_aStatsGZip = StatisticsManager.getCounterHandler(GZIPResponse.class);

    public GZIPResponse(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        super(httpServletRequest, httpServletResponse, string);
        s_aStatsGZip.increment();
    }

    @Override
    @Nonnull
    protected GZIPServletOutputStream createCompressedOutputStream(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull @Nonempty String string, long l, @Nonnegative long l2) throws IOException {
        return new GZIPServletOutputStream(httpServletRequest, httpServletResponse, string, l, l2);
    }

    public static class GZIPServletOutputStream
    extends AbstractCompressedServletOutputStream {
        public GZIPServletOutputStream(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull String string, long l, @Nonnegative long l2) throws IOException {
            super(httpServletRequest, httpServletResponse, string, l, l2);
        }

        @Override
        @Nonnull
        protected DeflaterOutputStream createDeflaterOutputStream(@Nonnull OutputStream outputStream) throws IOException {
            return new GZIPOutputStream(outputStream);
        }
    }
}

