/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.exchange.json;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.json.IJson;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriter;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.settings.ISettings;
import com.helger.settings.exchange.ISettingsPersistence;
import com.helger.settings.factory.ISettingsFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettingsPersistenceJson
implements ISettingsPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsPersistenceJson.class);
    private final ISettingsFactory<?> m_aSettingsFactory;
    private Charset m_aCharset = JsonReader.DEFAULT_CHARSET;

    public SettingsPersistenceJson() {
        this(ISettingsFactory.newInstance());
    }

    public SettingsPersistenceJson(@Nonnull ISettingsFactory<?> iSettingsFactory) {
        this.m_aSettingsFactory = ValueEnforcer.notNull(iSettingsFactory, "SettingsFactory");
    }

    @Override
    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Nonnull
    public final SettingsPersistenceJson setCharset(@Nonnull Charset charset) {
        ValueEnforcer.notNull(charset, "Charset");
        this.m_aCharset = charset;
        return this;
    }

    @Nonnull
    public final ISettingsFactory<?> getSettingsFactory() {
        return this.m_aSettingsFactory;
    }

    @Nonnull
    @Nonempty
    protected String getReadSettingsName() {
        return "anonymous";
    }

    private static void _recursiveReadSettings(@Nonnull String string, @Nonnull IJson iJson, @Nonnull ISettings iSettings) {
        if (iJson.isValue()) {
            iSettings.putIn(string, iJson.getAsValue().getAsString());
        } else if (iJson.isObject()) {
            for (Map.Entry entry : iJson.getAsObject()) {
                SettingsPersistenceJson._recursiveReadSettings(string + "." + (String)entry.getKey(), (IJson)entry.getValue(), iSettings);
            }
        } else {
            throw new IllegalArgumentException("JSON arrays are not supported in settings");
        }
    }

    @Override
    @Nonnull
    public ISettings readSettings(@Nonnull @WillClose InputStream inputStream) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        Object obj = this.m_aSettingsFactory.apply(this.getReadSettingsName());
        IJsonObject iJsonObject = JsonReader.builder().setSource(inputStream, this.m_aCharset).setCustomizeCallback(jsonParser -> {
            jsonParser.setRequireStringQuotes(false);
            jsonParser.setAlwaysUseBigNumber(true);
        }).readAsObject();
        if (iJsonObject != null) {
            for (Map.Entry entry : iJsonObject) {
                SettingsPersistenceJson._recursiveReadSettings((String)entry.getKey(), (IJson)entry.getValue(), obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ESuccess writeSettings(@Nonnull ISettings iSettings, @Nonnull @WillClose OutputStream outputStream) {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        try {
            JsonObject jsonObject = new JsonObject();
            for (Map.Entry object2 : CollectionHelper.getSorted(iSettings.entrySet(), Comparator.comparing(Map.Entry::getKey))) {
                String string = (String)object2.getKey();
                Object v = object2.getValue();
                String string2 = TypeConverter.convert(v, String.class);
                jsonObject.add(string, string2);
            }
            JsonWriterSettings jsonWriterSettings = new JsonWriterSettings();
            jsonWriterSettings.setIndentEnabled(true);
            jsonWriterSettings.setQuoteNames(false);
            new JsonWriter(jsonWriterSettings).writeToWriterAndClose(jsonObject, StreamHelper.createWriter(outputStream, this.m_aCharset));
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to write settings to JSON file", iOException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            StreamHelper.close(outputStream);
        }
    }
}

