/*
 * Decompiled with CFR 0.152.
 */
package com.helger.settings.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.functional.IFunction;
import com.helger.settings.ISettings;
import com.helger.settings.Settings;
import com.helger.settings.SettingsWithDefault;
import javax.annotation.Nonnull;

public interface ISettingsFactory<T extends ISettings>
extends IFunction<String, T> {
    @Override
    @Nonnull
    public T apply(@Nonnull @Nonempty String var1);

    @Nonnull
    public static ISettingsFactory<Settings> newInstance() {
        return Settings::new;
    }

    @Nonnull
    public static ISettingsFactory<SettingsWithDefault> newInstance(@Nonnull ISettings iSettings) {
        ValueEnforcer.notNull(iSettings, "DefaultSettings");
        return string -> new SettingsWithDefault(string, iSettings);
    }
}

