/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr1;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.bdxr1.IBDXRServiceGroupProvider;
import com.helger.smpclient.bdxr1.IBDXRServiceMetadataProvider;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerServiceGroupType;
import com.helger.smpclient.bdxr1.marshal.BDXR1MarshallerSignedServiceMetadataType;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.RedirectType;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataReferenceType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import com.helger.xsds.xmldsig.X509DataType;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDXRClientReadOnly
extends AbstractGenericSMPClient<BDXRClientReadOnly>
implements IBDXRServiceGroupProvider,
IBDXRServiceMetadataProvider {
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXRClientReadOnly.class);

    public BDXRClientReadOnly(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws PeppolDNSResolutionException {
        this(iPeppolURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public BDXRClientReadOnly(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws PeppolDNSResolutionException {
        this(iPeppolURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public BDXRClientReadOnly(@Nonnull URI uRI) {
        super(uRI);
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        return this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(new BDXR1MarshallerServiceGroupType(this.isXMLSchemaValidation())));
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory, @Nullable Consumer<String> consumer) {
        ValueEnforcer.notNull(iIdentifierFactory, "IdentifierFactory");
        CommonsArrayList<IDocumentTypeIdentifier> commonsArrayList = new CommonsArrayList<IDocumentTypeIdentifier>();
        if (serviceGroupType != null && serviceGroupType.getParticipantIdentifier() != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
            String string = "/" + CIdentifier.getURIEncoded(serviceGroupType.getParticipantIdentifier()) + "/" + URL_PART_SERVICES + "/";
            for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String string2;
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                String string3 = serviceMetadataReferenceType.getHref();
                String string4 = CIdentifier.createPercentDecoded(string3);
                boolean bl = false;
                int n = StringHelper.getIndexOfIgnoreCase(string4, string, Locale.US);
                if (n >= 0 && (iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string2 = string4.substring(n + string.length()))) != null) {
                    commonsArrayList.add(iDocumentTypeIdentifier);
                    bl = true;
                }
                if (bl || consumer == null) continue;
                consumer.accept(string3);
            }
        }
        return commonsArrayList;
    }

    @Deprecated
    @Nonnull
    public SignedServiceMetadataType getServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Nonnull
    public SignedServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/" + URL_PART_SERVICES + "/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BDXRClient getServiceRegistration@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        KeyStore keyStore = this.getTrustStore();
        HttpGet httpGet = new HttpGet(string);
        SignedServiceMetadataType signedServiceMetadataType = this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(new BDXR1MarshallerSignedServiceMetadataType(bl), keyStore).setVerifySignature(bl2));
        if (this.isFollowSMPRedirects() && signedServiceMetadataType.getServiceMetadata() != null && signedServiceMetadataType.getServiceMetadata().getRedirect() != null) {
            RedirectType redirectType = signedServiceMetadataType.getServiceMetadata().getRedirect();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Following a redirect from '" + string + "' to '" + redirectType.getHref() + "'");
            }
            httpGet = new HttpGet(redirectType.getHref());
            signedServiceMetadataType = this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(new BDXR1MarshallerSignedServiceMetadataType(bl), keyStore).setVerifySignature(bl2));
            boolean bl3 = false;
            block0: for (Object object : signedServiceMetadataType.getSignature().getKeyInfo().getContent()) {
                Object t = ((JAXBElement)object).getValue();
                if (!(t instanceof X509DataType)) continue;
                X509DataType x509DataType = (X509DataType)t;
                for (Object object2 : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    JAXBElement jAXBElement = (JAXBElement)object2;
                    if (!(jAXBElement.getValue() instanceof String)) continue;
                    String string2 = (String)jAXBElement.getValue();
                    if (!redirectType.getCertificateUID().equals(string2)) {
                        throw new SMPClientException("The certificate UID of the redirect did not match the certificate subject. Subject is '" + string2 + "'. Required certificate UID is '" + redirectType.getCertificateUID() + "'");
                    }
                    bl3 = true;
                    break block0;
                }
            }
            if (!bl3) {
                throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
            }
        }
        return signedServiceMetadataType;
    }

    @Deprecated
    @Nullable
    public SignedServiceMetadataType getServiceRegistrationOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Override
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull(signedServiceMetadataType, "SignedServiceMetadata");
        ValueEnforcer.notNull(signedServiceMetadataType.getServiceMetadata(), "SignedServiceMetadata.ServiceMetadata");
        if (signedServiceMetadataType.getServiceMetadata().getServiceInformation() == null) {
            return null;
        }
        ValueEnforcer.notNull(signedServiceMetadataType.getServiceMetadata().getServiceInformation().getProcessList(), "SignedServiceMetadata.ServiceMetadata.ServiceInformation.ProcessList");
        ValueEnforcer.notNull(iProcessIdentifier, "ProcessID");
        ValueEnforcer.notNull(iSMPTransportProfile, "TransportProfile");
        ServiceInformationType serviceInformationType = signedServiceMetadataType.getServiceMetadata().getServiceInformation();
        if (serviceInformationType != null) {
            for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
                if (!SimpleProcessIdentifier.wrap(processType.getProcessIdentifier()).hasSameContent(iProcessIdentifier)) continue;
                CommonsArrayList commonsArrayList = new CommonsArrayList();
                for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                    if (!iSMPTransportProfile.getID().equals(endpointType.getTransportProfile())) continue;
                    commonsArrayList.add(endpointType);
                }
                if (commonsArrayList.size() != 1 && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process " + iProcessIdentifier + " and transport profile " + iSMPTransportProfile.getID() + (commonsArrayList.isEmpty() ? "" : ": " + ((Object)commonsArrayList).toString() + " - using the first one"));
                }
                return (EndpointType)commonsArrayList.getFirst();
            }
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getEndpointURI();
    }

    @Nullable
    public static byte[] getEndpointCertificateBytes(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getCertificate();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        byte[] byArray = BDXRClientReadOnly.getEndpointCertificateBytes(endpointType);
        return CertificateHelper.convertByteArrayToCertficateDirect(byArray);
    }

    @Nullable
    public static X509Certificate getEndpointCertificateOrNull(@Nullable EndpointType endpointType) {
        try {
            return BDXRClientReadOnly.getEndpointCertificate(endpointType);
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new BDXRClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static SignedServiceMetadataType getServiceRegistrationByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new BDXRClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

