/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.bdxr1.utils;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.string.StringHelper;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.serialize.JsonReader;
import com.helger.json.serialize.JsonWriterSettings;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import com.helger.xsds.bdxr.smp1.ExtensionType;
import com.helger.xsds.bdxr.smp2.ec.SMPExtensionType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Immutable
public final class BDXR1ExtensionConverter {
    public static final String JSON_ID = "ID";
    public static final String JSON_NAME = "Name";
    public static final String JSON_AGENCY_ID = "AgencyID";
    public static final String JSON_AGENCY_NAME = "AgencyName";
    public static final String JSON_AGENCY_URI = "AgencyURI";
    public static final String JSON_VERSION_ID = "VersionID";
    public static final String JSON_URI = "URI";
    public static final String JSON_REASON_CODE = "ReasonCode";
    public static final String JSON_REASON = "Reason";
    public static final String JSON_ANY = "Any";
    private static final Logger LOGGER = LoggerFactory.getLogger(BDXR1ExtensionConverter.class);
    private static final XMLWriterSettings s_aXWS = new XMLWriterSettings().setIndent(EXMLSerializeIndent.NONE);
    private static final JsonWriterSettings s_aJWS = new JsonWriterSettings().setIndentEnabled(false).setWriteNewlineAtEnd(false);
    private static final BDXR1ExtensionConverter s_aInstance = new BDXR1ExtensionConverter();

    private BDXR1ExtensionConverter() {
    }

    @Nullable
    public static IJsonObject convertToJson(@Nullable ExtensionType extensionType) {
        if (extensionType != null && extensionType.getAny() != null) {
            Object object = extensionType.getAny();
            if (object instanceof Element) {
                object = XMLWriter.getNodeAsString((Element)object, s_aXWS);
            }
            JsonObject jsonObject = new JsonObject();
            if (extensionType.getExtensionID() != null) {
                jsonObject.add(JSON_ID, extensionType.getExtensionID());
            }
            if (extensionType.getExtensionName() != null) {
                jsonObject.add(JSON_NAME, extensionType.getExtensionName());
            }
            if (extensionType.getExtensionAgencyID() != null) {
                jsonObject.add(JSON_AGENCY_ID, extensionType.getExtensionAgencyID());
            }
            if (extensionType.getExtensionAgencyName() != null) {
                jsonObject.add(JSON_AGENCY_NAME, extensionType.getExtensionAgencyName());
            }
            if (extensionType.getExtensionAgencyURI() != null) {
                jsonObject.add(JSON_AGENCY_URI, extensionType.getExtensionAgencyURI());
            }
            if (extensionType.getExtensionVersionID() != null) {
                jsonObject.add(JSON_VERSION_ID, extensionType.getExtensionVersionID());
            }
            if (extensionType.getExtensionURI() != null) {
                jsonObject.add(JSON_URI, extensionType.getExtensionURI());
            }
            if (extensionType.getExtensionReasonCode() != null) {
                jsonObject.add(JSON_REASON_CODE, extensionType.getExtensionReasonCode());
            }
            if (extensionType.getExtensionReason() != null) {
                jsonObject.add(JSON_REASON, extensionType.getExtensionReason());
            }
            if (object != null) {
                jsonObject.add(JSON_ANY, object);
            }
            return jsonObject;
        }
        return null;
    }

    @Nullable
    public static IJsonArray convertToJson(@Nullable List<ExtensionType> list) {
        if (CollectionHelper.isNotEmpty(list)) {
            JsonArray jsonArray = new JsonArray();
            for (ExtensionType extensionType : list) {
                IJsonObject iJsonObject = BDXR1ExtensionConverter.convertToJson(extensionType);
                if (iJsonObject == null) continue;
                jsonArray.add(iJsonObject);
            }
            return jsonArray;
        }
        return null;
    }

    @Nullable
    public static String convertToString(@Nullable List<ExtensionType> list) {
        IJsonArray iJsonArray = BDXR1ExtensionConverter.convertToJson(list);
        return iJsonArray == null ? null : iJsonArray.getAsJsonString(s_aJWS);
    }

    @Nullable
    public static ICommonsList<ExtensionType> convertXMLToSingleExtension(@Nullable String string) {
        Element element;
        Document document;
        if (StringHelper.hasText(string) && (document = DOMReader.readXMLDOM(string)) != null && (element = document.getDocumentElement()) != null) {
            ExtensionType extensionType = new ExtensionType();
            extensionType.setAny(element);
            return new CommonsArrayList<ExtensionType>(extensionType);
        }
        return null;
    }

    @Nullable
    public static ICommonsList<ExtensionType> convert(@Nullable String string) {
        if (StringHelper.hasText(string)) {
            IJson iJson2 = JsonReader.readFromString(string);
            if (iJson2 == null || !iJson2.isArray()) {
                LOGGER.warn("Error in parsing extension JSON '" + string + "'");
            } else {
                CommonsArrayList<ExtensionType> commonsArrayList = new CommonsArrayList<ExtensionType>();
                iJson2.getAsArray().forEach(iJson -> {
                    Document document;
                    IJsonObject iJsonObject = iJson.getAsObject();
                    ExtensionType extensionType = new ExtensionType();
                    extensionType.setExtensionID(iJsonObject.getAsString(JSON_ID));
                    extensionType.setExtensionName(iJsonObject.getAsString(JSON_NAME));
                    extensionType.setExtensionAgencyID(iJsonObject.getAsString(JSON_AGENCY_ID));
                    extensionType.setExtensionAgencyName(iJsonObject.getAsString(JSON_AGENCY_NAME));
                    extensionType.setExtensionAgencyURI(iJsonObject.getAsString(JSON_AGENCY_URI));
                    extensionType.setExtensionVersionID(iJsonObject.getAsString(JSON_VERSION_ID));
                    extensionType.setExtensionURI(iJsonObject.getAsString(JSON_URI));
                    extensionType.setExtensionReasonCode(iJsonObject.getAsString(JSON_REASON_CODE));
                    extensionType.setExtensionReason(iJsonObject.getAsString(JSON_REASON));
                    String string = iJsonObject.getAsString(JSON_ANY);
                    if (StringHelper.hasText(string) && (document = DOMReader.readXMLDOM(string)) != null) {
                        extensionType.setAny(document.getDocumentElement());
                    }
                    commonsArrayList.add(extensionType);
                });
                return commonsArrayList;
            }
        }
        return null;
    }

    @Nonnull
    public static ExtensionType convertFromExtensionBDXR2(@Nonnull SMPExtensionType sMPExtensionType) {
        ExtensionType extensionType = new ExtensionType();
        extensionType.setExtensionID(sMPExtensionType.getIDValue());
        extensionType.setExtensionName(sMPExtensionType.getNameValue());
        extensionType.setExtensionAgencyID(sMPExtensionType.getExtensionAgencyIDValue());
        extensionType.setExtensionAgencyName(sMPExtensionType.getExtensionAgencyNameValue());
        extensionType.setExtensionAgencyURI(sMPExtensionType.getExtensionAgencyURIValue());
        extensionType.setExtensionVersionID(sMPExtensionType.getExtensionVersionIDValue());
        extensionType.setExtensionURI(sMPExtensionType.getExtensionURIValue());
        extensionType.setExtensionReasonCode(sMPExtensionType.getExtensionReasonCodeValue());
        extensionType.setExtensionReason(sMPExtensionType.getExtensionReasonValue());
        return extensionType;
    }
}

