/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.config;

import com.helger.peppol.utils.PeppolKeyStoreHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.settings.exchange.configfile.ConfigFile;
import com.helger.settings.exchange.configfile.ConfigFileBuilder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpHost;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SMPClientConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClientConfiguration.class);
    private static final ConfigFile s_aConfigFile;

    private SMPClientConfiguration() {
    }

    @Nonnull
    public static ConfigFile getConfigFile() {
        return s_aConfigFile;
    }

    @Nonnull
    public static EKeyStoreType getTrustStoreType() {
        String string = s_aConfigFile.getAsString("truststore.type");
        return EKeyStoreType.getFromIDCaseInsensitiveOrDefault(string, PeppolKeyStoreHelper.TRUSTSTORE_TYPE);
    }

    @Nonnull
    public static String getTrustStorePath() {
        String string = s_aConfigFile.getAsString("truststore.path");
        if (string == null) {
            string = s_aConfigFile.getAsString("truststore.location", "truststore/complete-truststore.jks");
        }
        return string;
    }

    @Nonnull
    public static String getTrustStorePassword() {
        return s_aConfigFile.getAsString("truststore.password", "peppol");
    }

    @Nullable
    public static KeyStore loadTrustStore() {
        try {
            return KeyStoreHelper.loadKeyStoreDirect((IKeyStoreType)SMPClientConfiguration.getTrustStoreType(), SMPClientConfiguration.getTrustStorePath(), SMPClientConfiguration.getTrustStorePassword());
        }
        catch (IOException | GeneralSecurityException exception) {
            return null;
        }
    }

    @Nullable
    public static HttpHost getHttpProxy() {
        String string = s_aConfigFile.getAsString("http.proxyHost");
        int n = s_aConfigFile.getAsInt("http.proxyPort", 0);
        if (string != null && n > 0) {
            return new HttpHost(string, n);
        }
        return null;
    }

    @Nullable
    public static UsernamePasswordCredentials getHttpProxyCredentials() {
        String string = s_aConfigFile.getAsString("http.proxyUsername");
        String string2 = s_aConfigFile.getAsString("http.proxyPassword");
        if (string != null && string2 != null) {
            return new UsernamePasswordCredentials(string, string2);
        }
        return null;
    }

    @Nullable
    public static String getNonProxyHosts() {
        return s_aConfigFile.getAsString("http.nonProxyHosts");
    }

    public static boolean isUseProxySystemProperties() {
        return s_aConfigFile.getAsBoolean("http.useSystemProperties", false);
    }

    public static boolean isUseDNSClientCache() {
        return s_aConfigFile.getAsBoolean("http.useDNSClientCache", true);
    }

    public static int getConnectionTimeoutMS() {
        return s_aConfigFile.getAsInt("http.connect.timeout.ms", 5000);
    }

    public static int getRequestTimeoutMS() {
        return s_aConfigFile.getAsInt("http.request.timeout.ms", 10000);
    }

    static {
        ConfigFileBuilder configFileBuilder = new ConfigFileBuilder().addPathFromSystemProperty("peppol.smp.client.properties.path").addPathFromSystemProperty("smp.client.properties.path").addPathFromEnvVar("SMP_CLIENT_CONFIG").addPath("private-smp-client.properties").addPath("smp-client.properties");
        s_aConfigFile = configFileBuilder.build();
        if (s_aConfigFile.isRead()) {
            LOGGER.info("Read SMP client properties from " + s_aConfigFile.getReadResource().getPath());
        } else {
            LOGGER.warn("Failed to read SMP client properties from " + configFileBuilder.getAllPaths());
        }
    }
}

