/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.simple.doctype.SimpleDocumentTypeIdentifier;
import com.helger.peppolid.simple.participant.SimpleParticipantIdentifier;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerWriteOperations;
import com.helger.smpclient.peppol.SMPClientReadOnly;
import com.helger.smpclient.peppol.jaxb.RedirectType;
import com.helger.smpclient.peppol.jaxb.ServiceGroupType;
import com.helger.smpclient.peppol.jaxb.ServiceInformationType;
import com.helger.smpclient.peppol.jaxb.ServiceMetadataType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceMetadataType;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPClient
extends SMPClientReadOnly {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClient.class);

    public SMPClient(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws PeppolDNSResolutionException {
        super(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo);
    }

    public SMPClient(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws PeppolDNSResolutionException {
        super(iPeppolURLProvider, iParticipantIdentifier, string);
    }

    public SMPClient(@Nonnull URI uRI) {
        super(uRI);
    }

    public void saveServiceGroup(@Nonnull ServiceGroupType serviceGroupType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(serviceGroupType, "ServiceGroup");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = new SMPMarshallerServiceGroupType(this.isXMLSchemaValidation()).getAsString(serviceGroupType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceGroup: " + serviceGroupType);
        }
        String string2 = this.getSMPHostURI() + CIdentifier.getURIPercentEncoded(serviceGroupType.getParticipantIdentifier());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient saveServiceGroup@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity(new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest(httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    @Nonnull
    public ServiceGroupType saveServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ParticipantID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceGroupType serviceGroupType = new ServiceGroupType();
        serviceGroupType.setParticipantIdentifier(new SimpleParticipantIdentifier(iParticipantIdentifier));
        this.saveServiceGroup(serviceGroupType, basicAuthClientCredentials);
        return serviceGroupType;
    }

    public void deleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient deleteServiceGroup@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest(httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }

    private void _saveServiceInformation(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull ServiceMetadataType serviceMetadataType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        String string = new SMPMarshallerServiceMetadataType(this.isXMLSchemaValidation()).getAsString(serviceMetadataType);
        if (string == null) {
            throw new IllegalArgumentException("Failed to serialize ServiceMetadata: " + serviceMetadataType);
        }
        String string2 = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/" + "services" + "/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient saveServiceRegistration@" + string2);
        }
        HttpPut httpPut = new HttpPut(string2);
        httpPut.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        httpPut.setEntity(new StringEntity(string, CONTENT_TYPE_TEXT_XML));
        this.executeGenericRequest(httpPut, new SMPHttpResponseHandlerWriteOperations());
    }

    public void saveServiceInformation(@Nonnull ServiceInformationType serviceInformationType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(serviceInformationType, "ServiceMetadata.ServiceInformation");
        ValueEnforcer.notNull(serviceInformationType.getParticipantIdentifier(), "ServiceMetadata.ServiceInformation.ParticipantIdentifier");
        ValueEnforcer.notNull(serviceInformationType.getDocumentIdentifier(), "ServiceMetadata.ServiceInformation.DocumentIdentifier");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setServiceInformation(serviceInformationType);
        this._saveServiceInformation(SimpleParticipantIdentifier.wrap(serviceInformationType.getParticipantIdentifier()), SimpleDocumentTypeIdentifier.wrap(serviceInformationType.getDocumentIdentifier()), serviceMetadataType, basicAuthClientCredentials);
    }

    public void saveServiceRedirect(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull RedirectType redirectType, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        ValueEnforcer.notNull(redirectType, "Redirect");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
        serviceMetadataType.setRedirect(redirectType);
        this._saveServiceInformation(iParticipantIdentifier, iDocumentTypeIdentifier, serviceMetadataType, basicAuthClientCredentials);
    }

    public void deleteServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/" + "services" + "/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient deleteServiceRegistration@" + string);
        }
        HttpDelete httpDelete = new HttpDelete(string);
        httpDelete.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        this.executeGenericRequest(httpDelete, new SMPHttpResponseHandlerWriteOperations());
    }
}

