/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.http.basicauth.BasicAuthClientCredentials;
import com.helger.peppol.sml.ISMLInfo;
import com.helger.peppol.smp.ISMPTransportProfile;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.ProcessIdentifierType;
import com.helger.peppolid.factory.IIdentifierFactory;
import com.helger.peppolid.factory.PeppolIdentifierFactory;
import com.helger.security.certificate.CertificateHelper;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.exception.SMPClientNotFoundException;
import com.helger.smpclient.httpclient.AbstractGenericSMPClient;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerSigned;
import com.helger.smpclient.httpclient.SMPHttpResponseHandlerUnsigned;
import com.helger.smpclient.peppol.ISMPServiceGroupProvider;
import com.helger.smpclient.peppol.ISMPServiceMetadataProvider;
import com.helger.smpclient.peppol.jaxb.CompleteServiceGroupType;
import com.helger.smpclient.peppol.jaxb.EndpointType;
import com.helger.smpclient.peppol.jaxb.ProcessType;
import com.helger.smpclient.peppol.jaxb.RedirectType;
import com.helger.smpclient.peppol.jaxb.ServiceGroupReferenceListType;
import com.helger.smpclient.peppol.jaxb.ServiceGroupType;
import com.helger.smpclient.peppol.jaxb.ServiceInformationType;
import com.helger.smpclient.peppol.jaxb.ServiceMetadataReferenceType;
import com.helger.smpclient.peppol.jaxb.SignedServiceMetadataType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerCompleteServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupReferenceListType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerServiceGroupType;
import com.helger.smpclient.peppol.marshal.SMPMarshallerSignedServiceMetadataType;
import com.helger.smpclient.peppol.utils.W3CEndpointReferenceHelper;
import com.helger.smpclient.url.IPeppolURLProvider;
import com.helger.smpclient.url.PeppolDNSResolutionException;
import com.helger.xsds.xmldsig.X509DataType;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPClientReadOnly
extends AbstractGenericSMPClient<SMPClientReadOnly>
implements ISMPServiceGroupProvider,
ISMPServiceMetadataProvider {
    public static final String URL_PART_COMPLETE = "complete";
    public static final String URL_PART_LIST = "list";
    public static final String URL_PART_SERVICES = "services";
    private static final Logger LOGGER = LoggerFactory.getLogger(SMPClientReadOnly.class);

    public SMPClientReadOnly(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ISMLInfo iSMLInfo) throws PeppolDNSResolutionException {
        this(iPeppolURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, iSMLInfo));
    }

    public SMPClientReadOnly(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull @Nonempty String string) throws PeppolDNSResolutionException {
        this(iPeppolURLProvider.getSMPURIOfParticipant(iParticipantIdentifier, string));
    }

    public SMPClientReadOnly(@Nonnull URI uRI) {
        super(uRI);
    }

    @Nonnull
    public ServiceGroupReferenceListType getServiceGroupReferenceList(@Nonnull String string, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        ValueEnforcer.notNull(string, "UserID");
        ValueEnforcer.notNull(basicAuthClientCredentials, "Credentials");
        String string2 = this.getSMPHostURI() + URL_PART_LIST + "/" + CIdentifier.createPercentEncoded(string);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceGroupReferenceList@" + string2);
        }
        HttpGet httpGet = new HttpGet(string2);
        httpGet.addHeader("Authorization", basicAuthClientCredentials.getRequestValue());
        return this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupReferenceListType>(new SMPMarshallerServiceGroupReferenceListType(this.isXMLSchemaValidation())));
    }

    @Nullable
    public ServiceGroupReferenceListType getServiceGroupReferenceListOrNull(@Nonnull String string, @Nonnull BasicAuthClientCredentials basicAuthClientCredentials) throws SMPClientException {
        try {
            return this.getServiceGroupReferenceList(string, basicAuthClientCredentials);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public CompleteServiceGroupType getCompleteServiceGroup(@Nonnull String string) throws SMPClientException {
        ValueEnforcer.notEmpty(string, "CompleteURL");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getCompleteServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        return this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerUnsigned<CompleteServiceGroupType>(new SMPMarshallerCompleteServiceGroupType(this.isXMLSchemaValidation())));
    }

    @Nonnull
    public CompleteServiceGroupType getCompleteServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        return this.getCompleteServiceGroup(this.getSMPHostURI() + URL_PART_COMPLETE + "/" + iParticipantIdentifier.getURIPercentEncoded());
    }

    @Nullable
    public CompleteServiceGroupType getCompleteServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getCompleteServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public ServiceGroupType getServiceGroup(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceGroup@" + string);
        }
        HttpGet httpGet = new HttpGet(string);
        return this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerUnsigned<ServiceGroupType>(new SMPMarshallerServiceGroupType(this.isXMLSchemaValidation())));
    }

    @Override
    @Nullable
    public ServiceGroupType getServiceGroupOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException {
        try {
            return this.getServiceGroup(iParticipantIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType) {
        return SMPClientReadOnly.getAllDocumentTypes(serviceGroupType, PeppolIdentifierFactory.INSTANCE, null);
    }

    @Nonnull
    public static ICommonsList<IDocumentTypeIdentifier> getAllDocumentTypes(@Nullable ServiceGroupType serviceGroupType, @Nonnull IIdentifierFactory iIdentifierFactory, @Nullable Consumer<String> consumer) {
        ValueEnforcer.notNull(iIdentifierFactory, "IdentifierFactory");
        CommonsArrayList<IDocumentTypeIdentifier> commonsArrayList = new CommonsArrayList<IDocumentTypeIdentifier>();
        if (serviceGroupType != null && serviceGroupType.getParticipantIdentifier() != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
            String string = "/" + CIdentifier.getURIEncoded(serviceGroupType.getParticipantIdentifier()) + "/" + URL_PART_SERVICES + "/";
            for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                String string2;
                IDocumentTypeIdentifier iDocumentTypeIdentifier;
                String string3 = serviceMetadataReferenceType.getHref();
                String string4 = CIdentifier.createPercentDecoded(string3);
                boolean bl = false;
                int n = StringHelper.getIndexOfIgnoreCase(string4, string, Locale.US);
                if (n >= 0 && (iDocumentTypeIdentifier = iIdentifierFactory.parseDocumentTypeIdentifier(string2 = string4.substring(n + string.length()))) != null) {
                    commonsArrayList.add(iDocumentTypeIdentifier);
                    bl = true;
                }
                if (bl || consumer == null) continue;
                consumer.accept(string3);
            }
        }
        return commonsArrayList;
    }

    @Deprecated
    @Nonnull
    public SignedServiceMetadataType getServiceRegistration(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Nonnull
    public SignedServiceMetadataType getServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        ValueEnforcer.notNull(iParticipantIdentifier, "ServiceGroupID");
        ValueEnforcer.notNull(iDocumentTypeIdentifier, "DocumentTypeID");
        String string = this.getSMPHostURI() + iParticipantIdentifier.getURIPercentEncoded() + "/" + URL_PART_SERVICES + "/" + iDocumentTypeIdentifier.getURIPercentEncoded();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SMPClient getServiceRegistration@" + string);
        }
        boolean bl = this.isXMLSchemaValidation();
        boolean bl2 = this.isVerifySignature();
        KeyStore keyStore = this.getTrustStore();
        HttpGet httpGet = new HttpGet(string);
        SignedServiceMetadataType signedServiceMetadataType = this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(new SMPMarshallerSignedServiceMetadataType(bl), keyStore).setVerifySignature(bl2));
        if (this.isFollowSMPRedirects() && signedServiceMetadataType.getServiceMetadata() != null && signedServiceMetadataType.getServiceMetadata().getRedirect() != null) {
            RedirectType redirectType = signedServiceMetadataType.getServiceMetadata().getRedirect();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Following a redirect from '" + string + "' to '" + redirectType.getHref() + "'");
            }
            httpGet = new HttpGet(redirectType.getHref());
            signedServiceMetadataType = this.executeGenericRequest(httpGet, new SMPHttpResponseHandlerSigned<SignedServiceMetadataType>(new SMPMarshallerSignedServiceMetadataType(bl), keyStore).setVerifySignature(bl2));
            boolean bl3 = false;
            block0: for (Object object : signedServiceMetadataType.getSignature().getKeyInfo().getContent()) {
                Object t = ((JAXBElement)object).getValue();
                if (!(t instanceof X509DataType)) continue;
                X509DataType x509DataType = (X509DataType)t;
                for (Object object2 : x509DataType.getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    JAXBElement jAXBElement = (JAXBElement)object2;
                    if (!(jAXBElement.getValue() instanceof String)) continue;
                    String string2 = (String)jAXBElement.getValue();
                    if (!redirectType.getCertificateUID().equals(string2)) {
                        throw new SMPClientException("The certificate UID of the redirect did not match the certificate subject. Subject is '" + string2 + "'. Required certificate UID is '" + redirectType.getCertificateUID() + "'");
                    }
                    bl3 = true;
                    break block0;
                }
            }
            if (!bl3) {
                throw new SMPClientException("The X509 certificate did not contain a certificate subject.");
            }
        }
        return signedServiceMetadataType;
    }

    @Deprecated
    @Nullable
    public SignedServiceMetadataType getServiceRegistrationOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        return this.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
    }

    @Override
    @Nullable
    public SignedServiceMetadataType getServiceMetadataOrNull(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException {
        try {
            return this.getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
        }
        catch (SMPClientNotFoundException sMPClientNotFoundException) {
            return null;
        }
    }

    private static boolean _hasSameContent(@Nonnull ProcessIdentifierType processIdentifierType, @Nonnull IProcessIdentifier iProcessIdentifier) {
        return EqualsHelper.equals(processIdentifierType.getScheme(), iProcessIdentifier.getScheme()) && EqualsHelper.equals(processIdentifierType.getValue(), iProcessIdentifier.getValue());
    }

    @Nullable
    public static EndpointType getEndpoint(@Nonnull SignedServiceMetadataType signedServiceMetadataType, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull ISMPTransportProfile iSMPTransportProfile) {
        ValueEnforcer.notNull(signedServiceMetadataType, "SignedServiceMetadata");
        ValueEnforcer.notNull(signedServiceMetadataType.getServiceMetadata(), "SignedServiceMetadata.ServiceMetadata");
        if (signedServiceMetadataType.getServiceMetadata().getServiceInformation() == null) {
            return null;
        }
        ValueEnforcer.notNull(signedServiceMetadataType.getServiceMetadata().getServiceInformation().getProcessList(), "SignedServiceMetadata.ServiceMetadata.ServiceInformation.ProcessList");
        ValueEnforcer.notNull(iProcessIdentifier, "ProcessID");
        ValueEnforcer.notNull(iSMPTransportProfile, "TransportProfile");
        ServiceInformationType serviceInformationType = signedServiceMetadataType.getServiceMetadata().getServiceInformation();
        if (serviceInformationType != null) {
            for (ProcessType processType : serviceInformationType.getProcessList().getProcess()) {
                if (!SMPClientReadOnly._hasSameContent(processType.getProcessIdentifier(), iProcessIdentifier)) continue;
                CommonsArrayList commonsArrayList = new CommonsArrayList();
                for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                    if (!iSMPTransportProfile.getID().equals(endpointType.getTransportProfile())) continue;
                    commonsArrayList.add(endpointType);
                }
                if (commonsArrayList.size() != 1 && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Found " + commonsArrayList.size() + " endpoints for process " + iProcessIdentifier + " and transport profile " + iSMPTransportProfile.getID() + (commonsArrayList.isEmpty() ? "" : ": " + ((Object)commonsArrayList).toString() + " - using the first one"));
                }
                return (EndpointType)commonsArrayList.getFirst();
            }
        }
        return null;
    }

    @Nullable
    public static String getEndpointAddress(@Nullable EndpointType endpointType) {
        return endpointType == null || endpointType.getEndpointReference() == null ? null : W3CEndpointReferenceHelper.getAddress(endpointType.getEndpointReference());
    }

    @Nullable
    public static String getEndpointCertificateString(@Nullable EndpointType endpointType) {
        return endpointType == null ? null : endpointType.getCertificate();
    }

    @Nullable
    public static X509Certificate getEndpointCertificate(@Nullable EndpointType endpointType) throws CertificateException {
        String string = SMPClientReadOnly.getEndpointCertificateString(endpointType);
        return CertificateHelper.convertStringToCertficate(string);
    }

    @Nonnull
    public static CompleteServiceGroupType getCompleteServiceGroupByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new SMPClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getCompleteServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static ServiceGroupType getServiceGroupByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new SMPClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getServiceGroup(iParticipantIdentifier);
    }

    @Nonnull
    public static SignedServiceMetadataType getServiceRegistrationByDNS(@Nonnull IPeppolURLProvider iPeppolURLProvider, @Nonnull ISMLInfo iSMLInfo, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier) throws SMPClientException, PeppolDNSResolutionException {
        return new SMPClientReadOnly(iPeppolURLProvider, iParticipantIdentifier, iSMLInfo).getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier);
    }
}

