/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol.utils;

import com.helger.peppolid.CIdentifier;
import com.helger.smpclient.peppol.jaxb.EndpointType;
import com.helger.smpclient.peppol.jaxb.ExtensionType;
import com.helger.smpclient.peppol.jaxb.ProcessType;
import com.helger.smpclient.peppol.jaxb.RedirectType;
import com.helger.smpclient.peppol.jaxb.ServiceGroupType;
import com.helger.smpclient.peppol.jaxb.ServiceInformationType;
import com.helger.smpclient.peppol.jaxb.ServiceMetadataReferenceCollectionType;
import com.helger.smpclient.peppol.jaxb.ServiceMetadataReferenceType;
import com.helger.smpclient.peppol.jaxb.ServiceMetadataType;
import com.helger.smpclient.peppol.utils.W3CEndpointReferenceHelper;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class SMPDebugHelper {
    private SMPDebugHelper() {
    }

    @Nonnull
    public static String getAsString(@Nonnull ServiceGroupType serviceGroupType) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ServiceGroup information:\n");
        stringBuilder.append("ParticipantIdentifier: ").append(CIdentifier.getURIEncoded(serviceGroupType.getParticipantIdentifier())).append('\n');
        ServiceMetadataReferenceCollectionType serviceMetadataReferenceCollectionType = serviceGroupType.getServiceMetadataReferenceCollection();
        if (serviceMetadataReferenceCollectionType != null && !serviceMetadataReferenceCollectionType.getServiceMetadataReference().isEmpty()) {
            stringBuilder.append("ServiceMetadataReferenceCollection:\n");
            object = serviceMetadataReferenceCollectionType.getServiceMetadataReference().iterator();
            while (object.hasNext()) {
                ServiceMetadataReferenceType serviceMetadataReferenceType = (ServiceMetadataReferenceType)object.next();
                stringBuilder.append("  ").append(serviceMetadataReferenceType.getHref()).append('\n');
            }
        }
        if ((object = serviceGroupType.getExtension()) != null && ((ExtensionType)object).getAny() != null) {
            stringBuilder.append("Extension:\n");
            stringBuilder.append("  Class = ").append(((ExtensionType)object).getAny().getClass().getName()).append('\n');
            stringBuilder.append("  Value = ").append(((ExtensionType)object).getAny()).append('\n');
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String getAsString(@Nonnull ServiceMetadataType serviceMetadataType) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Service meta data:\n");
        ServiceInformationType serviceInformationType = serviceMetadataType.getServiceInformation();
        if (serviceInformationType != null) {
            stringBuilder.append("  Service information:\n");
            stringBuilder.append("    Participant: ").append(CIdentifier.getURIEncoded(serviceInformationType.getParticipantIdentifier())).append('\n');
            stringBuilder.append("    Document type: ").append(CIdentifier.getURIEncoded(serviceInformationType.getDocumentIdentifier())).append('\n');
            object = serviceInformationType.getProcessList().getProcess().iterator();
            while (object.hasNext()) {
                ProcessType processType = (ProcessType)object.next();
                stringBuilder.append("      Process: ").append(CIdentifier.getURIEncoded(processType.getProcessIdentifier())).append('\n');
                for (EndpointType endpointType : processType.getServiceEndpointList().getEndpoint()) {
                    stringBuilder.append("        Endpoint: ").append(W3CEndpointReferenceHelper.getAddress(endpointType.getEndpointReference())).append('\n');
                    stringBuilder.append("        Transport profile: ").append(endpointType.getTransportProfile()).append('\n');
                    stringBuilder.append("        Business level signature: ").append(endpointType.isRequireBusinessLevelSignature()).append('\n');
                    stringBuilder.append("        Min auth level: ").append(endpointType.getMinimumAuthenticationLevel()).append('\n');
                    if (endpointType.getServiceActivationDate() != null) {
                        stringBuilder.append("        Valid from: ").append(endpointType.getServiceActivationDate()).append('\n');
                    }
                    if (endpointType.getServiceExpirationDate() != null) {
                        stringBuilder.append("        Valid to: ").append(endpointType.getServiceExpirationDate()).append('\n');
                    }
                    stringBuilder.append("        Certficiate string: ").append(endpointType.getCertificate()).append('\n');
                    stringBuilder.append("        Service description: ").append(endpointType.getServiceDescription()).append('\n');
                    stringBuilder.append("        Contact URL: ").append(endpointType.getTechnicalContactUrl()).append('\n');
                    stringBuilder.append("        Info URL: ").append(endpointType.getTechnicalInformationUrl()).append('\n');
                }
            }
        }
        if ((object = serviceMetadataType.getRedirect()) != null) {
            stringBuilder.append("  Service redirect:\n");
            stringBuilder.append("    Certificate UID: ").append(((RedirectType)object).getCertificateUID()).append('\n');
            stringBuilder.append("    Href: ").append(((RedirectType)object).getHref()).append('\n');
        }
        return stringBuilder.toString();
    }
}

