/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.peppol.utils;

import com.helger.commons.string.StringHelper;
import com.helger.smpclient.peppol.jaxb.ExtensionType;
import com.helger.xml.serialize.read.DOMReader;
import com.helger.xml.serialize.write.EXMLSerializeDocType;
import com.helger.xml.serialize.write.EXMLSerializeIndent;
import com.helger.xml.serialize.write.XMLWriter;
import com.helger.xml.serialize.write.XMLWriterSettings;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Document;

@Immutable
public final class SMPExtensionConverter {
    private static final XMLWriterSettings s_aXWS = new XMLWriterSettings().setSerializeDocType(EXMLSerializeDocType.IGNORE).setIndent(EXMLSerializeIndent.NONE);
    private static final SMPExtensionConverter s_aInstance = new SMPExtensionConverter();

    private SMPExtensionConverter() {
    }

    @Nullable
    public static String convertToString(@Nullable ExtensionType extensionType) {
        if (extensionType != null && extensionType.getAny() != null) {
            return XMLWriter.getNodeAsString(extensionType.getAny(), s_aXWS);
        }
        return null;
    }

    @Nullable
    public static ExtensionType convert(@Nullable String string) {
        Document document;
        if (StringHelper.hasText(string) && (document = DOMReader.readXMLDOM(string)) != null) {
            ExtensionType extensionType = new ExtensionType();
            extensionType.setAny(document.getDocumentElement());
            return extensionType;
        }
        return null;
    }
}

