/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smpclient.security;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.security.certificate.CertificateHelper;
import com.helger.security.keystore.ConstantKeySelectorResult;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TrustStoreBasedX509KeySelector
extends KeySelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrustStoreBasedX509KeySelector.class);
    private KeyStore m_aTrustStore;

    @Deprecated
    public TrustStoreBasedX509KeySelector(@Nonnull EKeyStoreType eKeyStoreType, @Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull(eKeyStoreType, "TrustStoreType");
        ValueEnforcer.notNull(string, "TrustStorePath");
        ValueEnforcer.notNull(string2, "TrustStorePassword");
        try {
            this.m_aTrustStore = KeyStoreHelper.loadKeyStoreDirect((IKeyStoreType)eKeyStoreType, string, string2);
        }
        catch (IOException | GeneralSecurityException exception) {
            throw new IllegalArgumentException("Failed to load truststore '" + string + "' of type " + eKeyStoreType);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loaded truststore '" + string + "' of type " + eKeyStoreType);
        }
    }

    public TrustStoreBasedX509KeySelector(@Nonnull KeyStore keyStore) {
        ValueEnforcer.notNull(keyStore, "TrustStore");
        this.m_aTrustStore = keyStore;
    }

    public static boolean algorithmEquals(@Nonnull String string, @Nonnull String string2) {
        if (string2.equalsIgnoreCase("DSA") ? string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || string.equalsIgnoreCase("http://www.w3.org/2009/xmldsig11#dsa-sha256") : (string2.equalsIgnoreCase("RSA") ? string.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1") || string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1") : string2.equalsIgnoreCase("EC") && (string.equalsIgnoreCase("http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384") || string.equalsIgnoreCase("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512")))) {
            return true;
        }
        if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("Algorithm mismatch between JCA/JCE public key algorithm name ('" + string2 + "') and signature algorithm URI ('" + string + "')");
        }
        return false;
    }

    @Override
    public KeySelectorResult select(@Nonnull KeyInfo keyInfo, KeySelector.Purpose purpose, @Nonnull AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        for (XMLStructure xMLStructure : keyInfo.getContent()) {
            if (!(xMLStructure instanceof X509Data)) continue;
            X509Data x509Data = (X509Data)xMLStructure;
            for (Object obj : x509Data.getContent()) {
                if (!(obj instanceof X509Certificate)) continue;
                X509Certificate x509Certificate = (X509Certificate)obj;
                try {
                    x509Certificate.checkValidity();
                    X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
                    PKIXParameters pKIXParameters = new PKIXParameters(this.m_aTrustStore);
                    pKIXParameters.setRevocationEnabled(false);
                    CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
                    CertPath certPath = certificateFactory.generateCertPath(new CommonsArrayList<X509Certificate>(x509CertificateArray));
                    CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
                    certPathValidator.validate(certPath, pKIXParameters);
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (!TrustStoreBasedX509KeySelector.algorithmEquals(algorithmMethod.getAlgorithm(), publicKey.getAlgorithm())) continue;
                    return new ConstantKeySelectorResult(publicKey);
                }
                catch (Exception exception) {
                    throw new KeySelectorException("Failed to select public key from certificate " + x509Certificate, exception);
                }
            }
        }
        throw new KeySelectorException("No public key found!");
    }
}

