/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.state.EChange;
import com.helger.commons.system.SystemProperties;
import com.helger.smtp.listener.IEmailDataTransportListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.logging.Level;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.mail.event.ConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class EmailGlobalSettings {
    public static final int DEFAULT_MAX_QUEUE_LENGTH = 500;
    public static final int DEFAULT_MAX_SEND_COUNT = 100;
    public static final boolean DEFAULT_USE_SSL = false;
    public static final boolean DEFAULT_USE_STARTTLS = false;
    public static final long DEFAULT_CONNECT_TIMEOUT_MILLISECS = 5000L;
    public static final long DEFAULT_TIMEOUT_MILLISECS = 10000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailGlobalSettings.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static int s_nMaxMailQueueLen = 500;
    @GuardedBy(value="s_aRWLock")
    private static int s_nMaxMailSendCount = 100;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bUseSSL = false;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bUseSTARTTLS = false;
    @GuardedBy(value="s_aRWLock")
    private static long s_nConnectionTimeoutMilliSecs = 5000L;
    @GuardedBy(value="s_aRWLock")
    private static long s_nTimeoutMilliSecs = 10000L;
    @GuardedBy(value="s_aRWLock")
    private static boolean s_bDebugSMTP = GlobalDebug.isDebugMode();
    @GuardedBy(value="s_aRWLock")
    private static ICommonsList<ConnectionListener> s_aConnectionListeners = new CommonsArrayList<ConnectionListener>();
    @GuardedBy(value="s_aRWLock")
    private static ICommonsList<IEmailDataTransportListener> s_aEmailDataTransportListeners = new CommonsArrayList<IEmailDataTransportListener>();

    private EmailGlobalSettings() {
    }

    @Nonnegative
    public static int getMaxMailQueueLength() {
        return s_aRWLock.readLockedInt(() -> s_nMaxMailQueueLen);
    }

    @Nonnegative
    public static int getMaxMailSendCount() {
        return s_aRWLock.readLockedInt(() -> s_nMaxMailSendCount);
    }

    @Nonnull
    public static EChange setMailQueueSize(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGT0(n, "MaxMailQueueLen");
        ValueEnforcer.isGT0(n2, "MaxMailSendCount");
        ValueEnforcer.isTrue(n >= n2, () -> "MaxMailQueueLen (" + n + ") must be >= than MaxMailSendCount (" + n2 + ")");
        return s_aRWLock.writeLockedGet(() -> {
            if (n == s_nMaxMailQueueLen && n2 == s_nMaxMailSendCount) {
                return EChange.UNCHANGED;
            }
            s_nMaxMailQueueLen = n;
            s_nMaxMailSendCount = n2;
            return EChange.CHANGED;
        });
    }

    public static boolean isUseSSL() {
        return s_aRWLock.readLockedBoolean(() -> s_bUseSSL);
    }

    @Nonnull
    public static EChange setUseSSL(boolean bl) {
        return s_aRWLock.writeLockedGet(() -> {
            if (s_bUseSSL == bl) {
                return EChange.UNCHANGED;
            }
            s_bUseSSL = bl;
            return EChange.CHANGED;
        });
    }

    public static boolean isUseSTARTTLS() {
        return s_aRWLock.readLockedBoolean(() -> s_bUseSTARTTLS);
    }

    @Nonnull
    public static EChange setUseSTARTTLS(boolean bl) {
        return s_aRWLock.writeLockedGet(() -> {
            if (s_bUseSTARTTLS == bl) {
                return EChange.UNCHANGED;
            }
            s_bUseSTARTTLS = bl;
            return EChange.CHANGED;
        });
    }

    @CheckForSigned
    public static long getConnectionTimeoutMilliSecs() {
        return s_aRWLock.readLockedLong(() -> s_nConnectionTimeoutMilliSecs);
    }

    @Nonnull
    public static EChange setConnectionTimeoutMilliSecs(long l) {
        return s_aRWLock.writeLockedGet(() -> {
            if (s_nConnectionTimeoutMilliSecs == l) {
                return EChange.UNCHANGED;
            }
            if (l <= 0L) {
                LOGGER.warn("You are setting an indefinite connection timeout for the mail transport api: " + l);
            }
            s_nConnectionTimeoutMilliSecs = l;
            return EChange.CHANGED;
        });
    }

    @CheckForSigned
    public static long getTimeoutMilliSecs() {
        return s_aRWLock.readLockedLong(() -> s_nTimeoutMilliSecs);
    }

    @Nonnull
    public static EChange setTimeoutMilliSecs(long l) {
        return s_aRWLock.writeLockedGet(() -> {
            if (s_nTimeoutMilliSecs == l) {
                return EChange.UNCHANGED;
            }
            if (l <= 0L) {
                LOGGER.warn("You are setting an indefinite socket timeout for the mail transport api: " + l);
            }
            s_nTimeoutMilliSecs = l;
            return EChange.CHANGED;
        });
    }

    public static boolean isDebugSMTP() {
        return s_aRWLock.readLockedBoolean(() -> s_bDebugSMTP);
    }

    @Nonnull
    public static EChange setDebugSMTP(boolean bl) {
        return s_aRWLock.writeLockedGet(() -> {
            if (s_bDebugSMTP == bl) {
                return EChange.UNCHANGED;
            }
            s_bDebugSMTP = bl;
            return EChange.CHANGED;
        });
    }

    public static void addConnectionListener(@Nonnull ConnectionListener connectionListener) {
        ValueEnforcer.notNull(connectionListener, "ConnectionListener");
        s_aRWLock.writeLockedBoolean(() -> s_aConnectionListeners.add(connectionListener));
    }

    @Nonnull
    public static EChange removeConnectionListener(@Nullable ConnectionListener connectionListener) {
        if (connectionListener == null) {
            return EChange.UNCHANGED;
        }
        return s_aRWLock.writeLockedGet(() -> s_aConnectionListeners.removeObject(connectionListener));
    }

    @Nonnull
    public static EChange removeAllConnectionListeners() {
        return s_aRWLock.writeLockedGet(s_aConnectionListeners::removeAll);
    }

    public static boolean hasConnectionListeners() {
        return s_aRWLock.readLockedBoolean(s_aConnectionListeners::isNotEmpty);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<ConnectionListener> getAllConnectionListeners() {
        return s_aRWLock.readLockedGet(s_aConnectionListeners::getClone);
    }

    public static void addEmailDataTransportListener(@Nonnull IEmailDataTransportListener iEmailDataTransportListener) {
        ValueEnforcer.notNull(iEmailDataTransportListener, "EmailDataTransportListener");
        s_aRWLock.writeLockedBoolean(() -> s_aEmailDataTransportListeners.add(iEmailDataTransportListener));
    }

    @Nonnull
    public static EChange removeEmailDataTransportListener(@Nullable IEmailDataTransportListener iEmailDataTransportListener) {
        if (iEmailDataTransportListener == null) {
            return EChange.UNCHANGED;
        }
        return s_aRWLock.writeLockedGet(() -> s_aEmailDataTransportListeners.removeObject(iEmailDataTransportListener));
    }

    @Nonnull
    public static EChange removeAllEmailDataTransportListeners() {
        return s_aRWLock.writeLockedGet(s_aEmailDataTransportListeners::removeAll);
    }

    public static boolean hasEmailDataTransportListeners() {
        return s_aRWLock.readLockedBoolean(s_aEmailDataTransportListeners::isNotEmpty);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IEmailDataTransportListener> getAllEmailDataTransportListeners() {
        return s_aRWLock.readLockedGet(s_aEmailDataTransportListeners::getClone);
    }

    @SuppressFBWarnings(value={"LG_LOST_LOGGER_DUE_TO_WEAK_REFERENCE"})
    public static void enableJavaxMailDebugging(boolean bl) {
        java.util.logging.Logger.getLogger("com.sun.mail.smtp").setLevel(bl ? Level.FINEST : Level.INFO);
        java.util.logging.Logger.getLogger("com.sun.mail.smtp.protocol").setLevel(bl ? Level.FINEST : Level.INFO);
        SystemProperties.setPropertyValue("mail.socket.debug", bl);
        SystemProperties.setPropertyValue("java.security.debug", bl ? "certpath" : null);
        SystemProperties.setPropertyValue("javax.net.debug", bl ? "trustmanager" : null);
    }

    public static boolean isJavaxMailDebuggingEnabled() {
        return java.util.logging.Logger.getLogger("com.sun.mail.smtp").getLevel().equals(Level.FINEST);
    }

    public static void setToDefault() {
        s_aRWLock.writeLocked(() -> {
            s_nMaxMailQueueLen = 500;
            s_nMaxMailSendCount = 100;
            s_bUseSSL = false;
            s_bUseSTARTTLS = false;
            s_nConnectionTimeoutMilliSecs = 5000L;
            s_nTimeoutMilliSecs = 10000L;
            s_bDebugSMTP = GlobalDebug.isDebugMode();
            s_aConnectionListeners.clear();
            s_aEmailDataTransportListeners.clear();
        });
    }
}

