/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.helger.commons.serialize.convert.SerializationConverter;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.data.EEmailAttachmentDisposition;
import com.helger.smtp.data.EmailAttachmentDataSource;
import com.helger.smtp.data.IEmailAttachment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.activation.FileTypeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EmailAttachment
implements IEmailAttachment {
    public static final EEmailAttachmentDisposition DEFAULT_DISPOSITION = EEmailAttachmentDisposition.ATTACHMENT;
    private String m_sFilename;
    private IHasInputStream m_aInputStreamProvider;
    private Charset m_aCharset;
    private String m_sContentType;
    private EEmailAttachmentDisposition m_eDisposition;

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray) {
        this(string, byArray, (Charset)null);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nullable Charset charset) {
        this(string, byArray, charset, DEFAULT_DISPOSITION);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nullable Charset charset, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this(string, byArray, charset, FileTypeMap.getDefaultFileTypeMap().getContentType(string), eEmailAttachmentDisposition);
    }

    public EmailAttachment(@Nonnull @Nonempty String string, @Nonnull byte[] byArray, @Nullable Charset charset, @Nullable String string2, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this(string, new ByteArrayInputStreamProvider(byArray), charset, string2, eEmailAttachmentDisposition);
    }

    public <ISP extends IHasInputStream & Serializable> EmailAttachment(@Nonnull @Nonempty String string, @Nonnull ISP ISP) {
        this(string, ISP, (Charset)null);
    }

    public <ISP extends IHasInputStream & Serializable> EmailAttachment(@Nonnull @Nonempty String string, @Nonnull ISP ISP, @Nullable Charset charset) {
        this(string, ISP, charset, DEFAULT_DISPOSITION);
    }

    public <ISP extends IHasInputStream & Serializable> EmailAttachment(@Nonnull @Nonempty String string, @Nonnull ISP ISP, @Nullable Charset charset, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this(string, ISP, charset, FileTypeMap.getDefaultFileTypeMap().getContentType(string), eEmailAttachmentDisposition);
    }

    public <ISP extends IHasInputStream & Serializable> EmailAttachment(@Nonnull @Nonempty String string, @Nonnull ISP ISP, @Nullable Charset charset, @Nullable String string2, @Nonnull EEmailAttachmentDisposition eEmailAttachmentDisposition) {
        this.m_sFilename = ValueEnforcer.notEmpty(string, "Filename");
        this.m_aInputStreamProvider = ValueEnforcer.notNull(ISP, "InputStreamProvider");
        this.m_aCharset = charset;
        this.m_sContentType = string2;
        this.m_eDisposition = ValueEnforcer.notNull(eEmailAttachmentDisposition, "Disposition");
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sFilename);
        objectOutputStream.writeObject(this.m_aInputStreamProvider);
        SerializationConverter.writeConvertedObject(this.m_aCharset, objectOutputStream);
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sContentType);
        objectOutputStream.writeObject(this.m_eDisposition);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_sFilename = StreamHelper.readSafeUTF(objectInputStream);
        this.m_aInputStreamProvider = (IHasInputStream)objectInputStream.readObject();
        this.m_aCharset = SerializationConverter.readConvertedObject(objectInputStream, Charset.class);
        this.m_sContentType = StreamHelper.readSafeUTF(objectInputStream);
        this.m_eDisposition = (EEmailAttachmentDisposition)objectInputStream.readObject();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getFilename() {
        return this.m_sFilename;
    }

    @Override
    @Nonnull
    public IHasInputStream getInputStreamProvider() {
        return this.m_aInputStreamProvider;
    }

    @Override
    @Nullable
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nullable
    public String getContentType() {
        return this.m_sContentType;
    }

    @Override
    @Nonnull
    public EEmailAttachmentDisposition getDisposition() {
        return this.m_eDisposition;
    }

    @Override
    @Nonnull
    public EmailAttachmentDataSource getAsDataSource() {
        return new EmailAttachmentDataSource(this.m_aInputStreamProvider, this.m_sFilename, this.m_sContentType, this.m_eDisposition);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAttachment emailAttachment = (EmailAttachment)object;
        return this.m_sFilename.equals(emailAttachment.m_sFilename) && EqualsHelper.equals(this.m_aCharset, emailAttachment.m_aCharset) && EqualsHelper.equals(this.m_sContentType, emailAttachment.m_sContentType) && this.m_eDisposition.equals(emailAttachment.m_eDisposition);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sFilename).append(this.m_aCharset).append(this.m_sContentType).append((Enum)this.m_eDisposition)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Filename", this.m_sFilename).append("InputStreamProvider", this.m_aInputStreamProvider).appendIfNotNull("Charset", this.m_aCharset).appendIfNotNull("ContentType", this.m_sContentType).append("Disposition", this.m_eDisposition).getToString();
    }
}

