/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.data.IEmailAttachment;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.smtp.data.IMutableEmailAttachmentList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class EmailAttachmentList
implements IMutableEmailAttachmentList {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailAttachmentList.class);
    private final ICommonsOrderedMap<String, IEmailAttachment> m_aMap = new CommonsLinkedHashMap<String, IEmailAttachment>();

    public EmailAttachmentList() {
    }

    public EmailAttachmentList(@Nullable IEmailAttachmentList iEmailAttachmentList) {
        if (iEmailAttachmentList != null) {
            for (IEmailAttachment iEmailAttachment : iEmailAttachmentList) {
                this.addAttachment(iEmailAttachment);
            }
        }
    }

    public EmailAttachmentList(IEmailAttachment ... iEmailAttachmentArray) {
        if (iEmailAttachmentArray != null) {
            for (IEmailAttachment iEmailAttachment : iEmailAttachmentArray) {
                this.addAttachment(iEmailAttachment);
            }
        }
    }

    @Override
    @Nonnegative
    public int size() {
        return this.m_aMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aMap.isEmpty();
    }

    @Override
    public final void addAttachment(@Nonnull IEmailAttachment iEmailAttachment) {
        ValueEnforcer.notNull(iEmailAttachment, "Attachment");
        String string = iEmailAttachment.getFilename();
        if (this.m_aMap.containsKey(string) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Overwriting email attachment with filename '" + string + "'");
        }
        this.m_aMap.put(string, iEmailAttachment);
    }

    @Override
    @Nonnull
    public EChange removeAttachment(@Nullable String string) {
        return this.m_aMap.removeObject(string);
    }

    @Override
    @Nonnull
    public EChange removeAll() {
        return this.m_aMap.removeAll();
    }

    @Override
    public boolean containsAttachment(@Nullable String string) {
        return this.m_aMap.containsKey(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllAttachmentFilenames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableObject(value="speed")
    @CodingStyleguideUnaware
    Collection<IEmailAttachment> directGetAllAttachments() {
        return this.m_aMap.values();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IEmailAttachment> getAllAttachments() {
        return this.m_aMap.copyOfValues();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IEmailAttachmentDataSource> getAsDataSourceList() {
        return CollectionHelper.newListMapped(this.m_aMap.values(), IEmailAttachment::getAsDataSource);
    }

    @Override
    @Nonnull
    public Iterator<IEmailAttachment> iterator() {
        return this.m_aMap.values().iterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EmailAttachmentList emailAttachmentList = (EmailAttachmentList)object;
        return this.m_aMap.equals(emailAttachmentList.m_aMap);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aMap)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("map", this.m_aMap).getToString();
    }
}

