/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.annotation.ContainsSoftMigration;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.email.EmailAddress;
import com.helger.commons.email.IEmailAddress;
import com.helger.smtp.data.EEmailType;
import com.helger.smtp.data.EmailAttachment;
import com.helger.smtp.data.EmailAttachmentList;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IEmailAttachmentList;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EmailDataMicroTypeConverter
implements IMicroTypeConverter<EmailData> {
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_PERSONAL = "personal";
    private static final String ELEMENT_FROM = "from";
    private static final String ELEMENT_REPLYTO = "replyto";
    private static final String ELEMENT_TO = "to";
    private static final String ELEMENT_CC = "cc";
    private static final String ELEMENT_BCC = "bcc";
    private static final String ATTR_SENTDATETIME = "sentdatetime";
    private static final String ATTR_SUBJECT = "subject";
    private static final String ELEMENT_BODY = "body";
    private static final String ELEMENT_ATTACHMENTS = "attachments";
    private static final String ELEMENT_CUSTOM = "custom";
    private static final String ATTR_ID = "id";

    private static void _writeEmailAddress(@Nonnull IMicroElement iMicroElement, @Nonnull IEmailAddress iEmailAddress) {
        iMicroElement.setAttribute(ATTR_ADDRESS, iEmailAddress.getAddress());
        if (iEmailAddress.getPersonal() != null) {
            iMicroElement.setAttribute(ATTR_PERSONAL, iEmailAddress.getPersonal());
        }
    }

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull EmailData emailData, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_TYPE, emailData.getEmailType().getID());
        if (emailData.getFrom() != null) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_FROM), emailData.getFrom());
        }
        for (IEmailAddress object : emailData.replyTo()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_REPLYTO), object);
        }
        for (IEmailAddress iEmailAddress : emailData.to()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_TO), iEmailAddress);
        }
        for (IEmailAddress iEmailAddress : emailData.cc()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_CC), iEmailAddress);
        }
        for (IEmailAddress iEmailAddress : emailData.bcc()) {
            EmailDataMicroTypeConverter._writeEmailAddress(microElement.appendElement(string, ELEMENT_BCC), iEmailAddress);
        }
        if (emailData.getSentDateTime() != null) {
            microElement.setAttributeWithConversion(ATTR_SENTDATETIME, (Object)emailData.getSentDateTime());
        }
        if (emailData.getSubject() != null) {
            microElement.setAttribute(ATTR_SUBJECT, emailData.getSubject());
        }
        if (emailData.getBody() != null) {
            microElement.appendElement(string, ELEMENT_BODY).appendText(emailData.getBody());
        }
        microElement.appendChild(MicroTypeConverter.convertToMicroElement(emailData.getAttachments(), string, ELEMENT_ATTACHMENTS));
        for (Map.Entry entry : emailData.attrs().getSortedByKey(Comparator.naturalOrder()).entrySet()) {
            IMicroElement iMicroElement = microElement.appendElement(string, ELEMENT_CUSTOM);
            iMicroElement.setAttribute(ATTR_ID, (String)entry.getKey());
            iMicroElement.appendText((CharSequence)entry.getValue());
        }
        return microElement;
    }

    @Nonnull
    private static IEmailAddress _readEmailAddress(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_ADDRESS);
        String string2 = iMicroElement.getAttributeValue(ATTR_PERSONAL);
        return new EmailAddress(string, string2);
    }

    @Override
    @Nonnull
    @ContainsSoftMigration
    public EmailData convertToNative(@Nonnull IMicroElement iMicroElement) {
        Iterator iterator;
        String string = iMicroElement.getAttributeValue(ATTR_TYPE);
        EEmailType eEmailType = EEmailType.getFromIDOrNull(string);
        EmailData emailData = new EmailData(eEmailType);
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_FROM);
        emailData.setFrom(EmailDataMicroTypeConverter._readEmailAddress(iMicroElement2));
        for (IMicroElement object2 : iMicroElement.getAllChildElements(ELEMENT_REPLYTO)) {
            emailData.replyTo().add(EmailDataMicroTypeConverter._readEmailAddress(object2));
        }
        for (IMicroElement iMicroElement3 : iMicroElement.getAllChildElements(ELEMENT_TO)) {
            emailData.to().add(EmailDataMicroTypeConverter._readEmailAddress(iMicroElement3));
        }
        for (IMicroElement iMicroElement4 : iMicroElement.getAllChildElements(ELEMENT_CC)) {
            emailData.cc().add(EmailDataMicroTypeConverter._readEmailAddress(iMicroElement4));
        }
        for (IMicroElement iMicroElement5 : iMicroElement.getAllChildElements(ELEMENT_BCC)) {
            emailData.bcc().add(EmailDataMicroTypeConverter._readEmailAddress(iMicroElement5));
        }
        LocalDateTime localDateTime = iMicroElement.getAttributeValueWithConversion(ATTR_SENTDATETIME, LocalDateTime.class);
        if (localDateTime != null) {
            emailData.setSentDateTime(localDateTime);
        } else {
            String string2 = iMicroElement.getAttributeValue("sentdate");
            if (string2 != null && (iterator = PDTWebDateHelper.getDateTimeFromXSD(string2)) != null) {
                emailData.setSentDateTime(((ZonedDateTime)((Object)iterator)).toLocalDateTime());
            }
        }
        emailData.setSubject(iMicroElement.getAttributeValue(ATTR_SUBJECT));
        emailData.setBody(MicroHelper.getChildTextContent(iMicroElement, ELEMENT_BODY));
        IMicroElement iMicroElement6 = iMicroElement.getFirstChildElement(ELEMENT_ATTACHMENTS);
        if (iMicroElement6 != null) {
            emailData.setAttachments(MicroTypeConverter.convertToNative(iMicroElement6, EmailAttachmentList.class));
        } else {
            iterator = new EmailAttachmentList();
            for (IMicroElement iMicroElement7 : iMicroElement.getAllChildElements("attachment")) {
                ((EmailAttachmentList)((Object)iterator)).addAttachment(MicroTypeConverter.convertToNative(iMicroElement7, EmailAttachment.class));
            }
            if (!((EmailAttachmentList)((Object)iterator)).isEmpty()) {
                emailData.setAttachments((IEmailAttachmentList)((Object)iterator));
            }
        }
        for (IMicroElement iMicroElement8 : iMicroElement.getAllChildElements(ELEMENT_CUSTOM)) {
            emailData.attrs().putIn(iMicroElement8.getAttributeValue(ATTR_ID), iMicroElement8.getTextContent());
        }
        return emailData;
    }
}

