/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.data;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.string.StringHelper;
import com.helger.smtp.data.EEmailAttachmentDisposition;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IEmailAttachment
extends IHasInputStream,
Serializable {
    @Nonnull
    @Nonempty
    public String getFilename();

    @Nonnull
    public IHasInputStream getInputStreamProvider();

    @Override
    @Nonnull
    default public InputStream getInputStream() {
        return this.getInputStreamProvider().getInputStream();
    }

    @Override
    default public boolean isReadMultiple() {
        return this.getInputStreamProvider().isReadMultiple();
    }

    @Nullable
    public Charset getCharset();

    default public boolean hasCharset() {
        return this.getCharset() != null;
    }

    @Nullable
    public String getContentType();

    default public boolean hasContentType() {
        return StringHelper.hasText(this.getContentType());
    }

    @Nonnull
    public EEmailAttachmentDisposition getDisposition();

    @Nonnull
    public IEmailAttachmentDataSource getAsDataSource();
}

