/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.failed;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ITypedObject;
import com.helger.commons.type.ObjectType;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailTransportError;
import java.io.Serializable;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FailedMailData
implements ITypedObject<String>,
Serializable {
    public static final ObjectType TYPE_FAILEDMAIL = new ObjectType("failedmail");
    private final String m_sID;
    private final LocalDateTime m_aErrorDT;
    private final ISMTPSettings m_aSettings;
    private final LocalDateTime m_aOriginalSentDateTime;
    private final IMutableEmailData m_aEmailData;
    private final MailTransportError m_aError;

    public FailedMailData(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull MailTransportError mailTransportError) {
        this(iSMTPSettings, null, mailTransportError);
    }

    public FailedMailData(@Nonnull ISMTPSettings iSMTPSettings, @Nullable IMutableEmailData iMutableEmailData) {
        this(iSMTPSettings, iMutableEmailData, null);
    }

    public FailedMailData(@Nonnull ISMTPSettings iSMTPSettings, @Nullable IMutableEmailData iMutableEmailData, @Nullable MailTransportError mailTransportError) {
        this(GlobalIDFactory.getNewPersistentStringID(), PDTFactory.getCurrentLocalDateTime(), iSMTPSettings, iMutableEmailData == null ? null : iMutableEmailData.getSentDateTime(), iMutableEmailData, mailTransportError);
    }

    public FailedMailData(@Nonnull String string, @Nonnull LocalDateTime localDateTime, @Nonnull ISMTPSettings iSMTPSettings, @Nullable LocalDateTime localDateTime2, @Nullable IMutableEmailData iMutableEmailData, @Nullable MailTransportError mailTransportError) {
        this.m_sID = ValueEnforcer.notNull(string, "ID");
        this.m_aErrorDT = ValueEnforcer.notNull(localDateTime, "ErrorDT");
        this.m_aSettings = ValueEnforcer.notNull(iSMTPSettings, "Settings");
        this.m_aOriginalSentDateTime = localDateTime2 != null ? localDateTime2 : (iMutableEmailData != null ? iMutableEmailData.getSentDateTime() : null);
        this.m_aEmailData = iMutableEmailData;
        this.m_aError = mailTransportError;
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return TYPE_FAILEDMAIL;
    }

    @Override
    @Nonnull
    public String getID() {
        return this.m_sID;
    }

    @Nonnull
    public LocalDateTime getErrorDateTime() {
        return this.m_aErrorDT;
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSettings;
    }

    @Nullable
    public LocalDateTime getOriginalSentDateTime() {
        return this.m_aOriginalSentDateTime;
    }

    @Nullable
    public IMutableEmailData getEmailData() {
        return this.m_aEmailData;
    }

    @Nullable
    public MailTransportError getTransportError() {
        return this.m_aError;
    }

    public boolean hasTransportError() {
        return this.m_aError != null;
    }

    @Nullable
    public Throwable getTransportThrowable() {
        return this.m_aError == null ? null : this.m_aError.getThrowable();
    }

    @Nonnull
    public String getSMTPServerDisplayText() {
        String string = this.m_aSettings.getHostName();
        if (this.m_aSettings.hasPort()) {
            string = string + ":" + this.m_aSettings.getPort();
        }
        if (this.m_aSettings.hasUserName()) {
            string = string + "[" + this.m_aSettings.getUserName();
            if (this.m_aSettings.hasPassword()) {
                string = string + "/****";
            }
            string = string + ']';
        }
        return string;
    }

    @Nonnull
    public String getSenderDisplayText() {
        return this.m_aEmailData == null ? "" : this.m_aEmailData.getFrom().getDisplayName();
    }

    @Nonnull
    public String getRecipientDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_aEmailData != null) {
            for (IEmailAddress iEmailAddress : this.m_aEmailData.to()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append("; ");
                }
                stringBuilder.append(iEmailAddress.getDisplayName());
            }
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getTransportThrowableMessage() {
        return this.m_aError == null ? null : this.m_aError.getThrowable().getMessage();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        FailedMailData failedMailData = (FailedMailData)object;
        return this.m_sID.equals(failedMailData.m_sID) && this.m_aErrorDT.equals(failedMailData.m_aErrorDT) && this.m_aSettings.equals(failedMailData.m_aSettings) && EqualsHelper.equals(this.m_aOriginalSentDateTime, failedMailData.m_aOriginalSentDateTime) && EqualsHelper.equals(this.m_aEmailData, failedMailData.m_aEmailData) && EqualsHelper.equals(this.getTransportThrowableMessage(), failedMailData.getTransportThrowableMessage());
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sID).append(this.m_aErrorDT).append(this.m_aSettings).append(this.m_aOriginalSentDateTime).append(this.m_aEmailData).append(this.getTransportThrowableMessage()).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("id", this.m_sID).append("errorDateTime", this.m_aErrorDT).append("settings", this.m_aSettings).appendIfNotNull("originalSentDateTime", this.m_aOriginalSentDateTime).appendIfNotNull("emailData", this.m_aEmailData).appendIfNotNull("error", this.m_aError).getToString();
    }
}

