/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.failed;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.smtp.data.EmailData;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.settings.SMTPSettings;
import com.helger.smtp.transport.ESMTPErrorCode;
import com.helger.smtp.transport.MailSendDetails;
import com.helger.smtp.transport.MailTransportError;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import com.helger.xml.microdom.util.MicroHelper;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailedMailDataMicroTypeConverter
implements IMicroTypeConverter<FailedMailData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FailedMailDataMicroTypeConverter.class);
    private static final String ATTR_ID = "id";
    private static final String ATTR_ERRORDT = "errordt";
    private static final String ATTR_ORIGINALSENT_DT = "originalsentdt";
    private static final String ELEMENT_SMTP_SETTINGS = "smtpsettings";
    private static final String ELEMENT_EMAIL_DATA = "emaildata";
    private static final String ELEMENT_ERROR_MSG = "errormsg";
    private static final String ELEMENT_DETAILS = "details";
    private static final String ATTR_ADDRESS_VALID = "addressvalid";
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_COMMAND = "command";
    private static final String ATTR_ERROR_MESSAGE = "errormsg";
    private static final String ATTR_ERROR_CODE = "errcode";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull FailedMailData failedMailData, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_ID, failedMailData.getID());
        microElement.setAttributeWithConversion(ATTR_ERRORDT, (Object)failedMailData.getErrorDateTime());
        microElement.setAttributeWithConversion(ATTR_ORIGINALSENT_DT, (Object)failedMailData.getOriginalSentDateTime());
        microElement.appendChild(MicroTypeConverter.convertToMicroElement(failedMailData.getSMTPSettings(), string, ELEMENT_SMTP_SETTINGS));
        microElement.appendChild(MicroTypeConverter.convertToMicroElement(failedMailData.getEmailData(), string, ELEMENT_EMAIL_DATA));
        MailTransportError mailTransportError = failedMailData.getTransportError();
        if (mailTransportError != null) {
            microElement.appendElement(string, "errormsg").appendText(mailTransportError.getThrowable().getMessage());
            for (MailSendDetails mailSendDetails : mailTransportError.getAllDetails()) {
                ((IMicroElement)((IMicroElement)((IMicroElement)((IMicroElement)microElement.appendElement(string, ELEMENT_DETAILS).setAttribute(ATTR_ADDRESS_VALID, mailSendDetails.isAddressValid())).setAttribute(ATTR_ADDRESS, mailSendDetails.getAddress())).setAttribute(ATTR_COMMAND, mailSendDetails.getCommand())).setAttribute("errormsg", mailSendDetails.getErrorMessage())).setAttribute(ATTR_ERROR_CODE, mailSendDetails.getErrorCode().getECode());
            }
        }
        return microElement;
    }

    @Override
    @Nullable
    public FailedMailData convertToNative(@Nonnull IMicroElement iMicroElement) {
        IMicroElement iMicroElement2;
        String string = iMicroElement.getAttributeValue(ATTR_ID);
        if (string == null) {
            LOGGER.error("Failed to read ID");
            return null;
        }
        String string2 = iMicroElement.getAttributeValue(ATTR_ERRORDT);
        if (string2 == null) {
            LOGGER.error("Failed to read error date/time");
            return null;
        }
        LocalDateTime localDateTime = PDTWebDateHelper.getLocalDateTimeFromXSD(string2);
        if (localDateTime == null) {
            localDateTime = TypeConverter.convert(string2, LocalDateTime.class);
        }
        if (localDateTime == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Failed to parse error date '" + string2 + "'");
            }
            return null;
        }
        String string3 = iMicroElement.getAttributeValue(ATTR_ORIGINALSENT_DT);
        LocalDateTime localDateTime2 = null;
        if (string3 != null && (localDateTime2 = PDTWebDateHelper.getLocalDateTimeFromXSD(string3)) == null) {
            localDateTime2 = TypeConverter.convert(string3, LocalDateTime.class);
        }
        if ((iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_SMTP_SETTINGS)) == null) {
            LOGGER.error("Failed to get child element of SMTP settings!");
            return null;
        }
        ISMTPSettings iSMTPSettings = MicroTypeConverter.convertToNative(iMicroElement2, SMTPSettings.class);
        IMicroElement iMicroElement3 = iMicroElement.getFirstChildElement(ELEMENT_EMAIL_DATA);
        IMutableEmailData iMutableEmailData = MicroTypeConverter.convertToNative(iMicroElement3, EmailData.class);
        String string4 = MicroHelper.getChildTextContent(iMicroElement, "errormsg");
        Exception exception = StringHelper.hasNoText(string4) ? null : new Exception(string4);
        MailTransportError mailTransportError = null;
        if (exception != null) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            for (IMicroElement iMicroElement4 : iMicroElement.getAllChildElements(ELEMENT_DETAILS)) {
                boolean bl = StringParser.parseBool(iMicroElement4.getAttributeValue(ATTR_ADDRESS_VALID));
                String string5 = iMicroElement4.getAttributeValue(ATTR_ADDRESS);
                String string6 = iMicroElement4.getAttributeValue(ATTR_COMMAND);
                String string7 = iMicroElement4.getAttributeValue("errormsg");
                int n = StringParser.parseInt(iMicroElement4.getAttributeValue(ATTR_ERROR_CODE), -1);
                ESMTPErrorCode eSMTPErrorCode = ESMTPErrorCode.getFromIDOrDefault(n, ESMTPErrorCode.FALLBACK);
                commonsArrayList.add(new MailSendDetails(bl, string5, string6, string7, eSMTPErrorCode));
            }
            mailTransportError = new MailTransportError(exception, commonsArrayList);
        }
        return new FailedMailData(string, localDateTime, iSMTPSettings, localDateTime2, iMutableEmailData, mailTransportError);
    }
}

