/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.failed;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.failed.FailedMailData;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FailedMailQueue
implements Serializable {
    private static final IMutableStatisticsHandlerCounter s_aStatsCountAdd = StatisticsManager.getCounterHandler(FailedMailQueue.class.getName() + "$add");
    private static final IMutableStatisticsHandlerCounter s_aStatsCountRemove = StatisticsManager.getCounterHandler(FailedMailQueue.class.getName() + "$remove");
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsOrderedMap<String, FailedMailData> m_aMap = new CommonsLinkedHashMap<String, FailedMailData>();

    @MustBeLocked(value=ELockType.WRITE)
    protected void internalAdd(@Nonnull FailedMailData failedMailData) {
        this.m_aMap.put(failedMailData.getID(), failedMailData);
        s_aStatsCountAdd.increment();
    }

    public void add(@Nonnull FailedMailData failedMailData) {
        ValueEnforcer.notNull(failedMailData, "FailedMailData");
        this.m_aRWLock.writeLocked(() -> this.internalAdd(failedMailData));
    }

    @Nullable
    @MustBeLocked(value=ELockType.WRITE)
    protected FailedMailData internalRemove(@Nullable String string) {
        FailedMailData failedMailData = (FailedMailData)this.m_aMap.remove(string);
        if (failedMailData != null) {
            s_aStatsCountRemove.increment();
        }
        return failedMailData;
    }

    @Nullable
    public FailedMailData remove(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.writeLockedGet(() -> this.internalRemove(string));
    }

    @Nonnegative
    @MustBeLocked(value=ELockType.READ)
    protected int internalSize() {
        return this.m_aMap.size();
    }

    @Nonnegative
    public int size() {
        return this.m_aRWLock.readLockedInt(this::internalSize);
    }

    @Nullable
    @MustBeLocked(value=ELockType.READ)
    protected FailedMailData internalGetFailedMailOfID(@Nullable String string) {
        return (FailedMailData)this.m_aMap.get(string);
    }

    @Nullable
    public FailedMailData getFailedMailOfID(@Nullable String string) {
        return this.m_aRWLock.readLockedGet(() -> this.internalGetFailedMailOfID(string));
    }

    @Nonnegative
    @MustBeLocked(value=ELockType.READ)
    protected int internalGetFailedMailCount() {
        return this.m_aMap.size();
    }

    @Nonnegative
    public int getFailedMailCount() {
        return this.m_aRWLock.readLockedInt(this::internalGetFailedMailCount);
    }

    @Nonnull
    @ReturnsMutableCopy
    @MustBeLocked(value=ELockType.READ)
    protected ICommonsList<FailedMailData> internalGetAllFailedMails() {
        return this.m_aMap.copyOfValues();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<FailedMailData> getAllFailedMails() {
        return this.m_aRWLock.readLockedGet(this::internalGetAllFailedMails);
    }

    @Nonnull
    @ReturnsMutableCopy
    @MustBeLocked(value=ELockType.WRITE)
    protected ICommonsList<FailedMailData> internalRemoveAll() {
        CommonsArrayList<int> commonsArrayList = new CommonsArrayList<int>(this.m_aMap.size());
        if (!this.m_aMap.isEmpty()) {
            commonsArrayList.addAll(this.m_aMap.values());
            this.m_aMap.clear();
        }
        return commonsArrayList;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<FailedMailData> removeAll() {
        return this.m_aRWLock.writeLockedGet(this::internalRemoveAll);
    }

    public String toString() {
        return new ToStringGenerator(this).append("Map", this.m_aMap).getToString();
    }
}

