/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.listener;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.smtp.data.IEmailData;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailSendDetails;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.mail.internet.MimeMessage;

@Immutable
public class EmailDataTransportEvent {
    private final ISMTPSettings m_aSMTPSettings;
    private final IEmailData m_aEmailData;
    private final MimeMessage m_aMimeMessage;
    private final ICommonsList<MailSendDetails> m_aValidSent;
    private final ICommonsList<MailSendDetails> m_aValidUnsent;
    private final ICommonsList<MailSendDetails> m_aInvalid;

    public EmailDataTransportEvent(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull IEmailData iEmailData, @Nonnull MimeMessage mimeMessage, @Nonnull Collection<MailSendDetails> collection, @Nonnull Collection<MailSendDetails> collection2, @Nonnull Collection<MailSendDetails> collection3) {
        ValueEnforcer.notNull(iSMTPSettings, "SMTPSettings");
        ValueEnforcer.notNull(iEmailData, "EmailData");
        ValueEnforcer.notNull(mimeMessage, "MimeMessage");
        ValueEnforcer.notNull(collection, "ValidSent");
        ValueEnforcer.notNull(collection2, "ValidUnsent");
        ValueEnforcer.notNull(collection3, "Invalid");
        this.m_aSMTPSettings = iSMTPSettings;
        this.m_aEmailData = iEmailData;
        this.m_aMimeMessage = mimeMessage;
        this.m_aValidSent = new CommonsArrayList<Collection<MailSendDetails>>(collection);
        this.m_aValidUnsent = new CommonsArrayList<Collection<MailSendDetails>>(collection2);
        this.m_aInvalid = new CommonsArrayList<Collection<MailSendDetails>>(collection3);
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    public IEmailData getEmailData() {
        return this.m_aEmailData;
    }

    @Nonnull
    public MimeMessage getMimeMessage() {
        return this.m_aMimeMessage;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MailSendDetails> getValidSentAddresses() {
        return (ICommonsList)this.m_aValidSent.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MailSendDetails> getValidUnsentAddresses() {
        return (ICommonsList)this.m_aValidUnsent.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MailSendDetails> getInvalidAddresses() {
        return (ICommonsList)this.m_aInvalid.getClone();
    }
}

