/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.settings;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.serialize.convert.SerializationConverter;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.network.port.NetworkPortHelper;
import com.helger.smtp.CSMTP;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.settings.ISMTPSettings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SMTPSettings
implements ISMTPSettings,
ICloneable<SMTPSettings> {
    private String m_sHostName;
    private int m_nPort;
    private String m_sUserName;
    private String m_sPassword;
    private transient Charset m_aCharset;
    private boolean m_bSSLEnabled;
    private boolean m_bSTARTTLSEnabled;
    private long m_nConnectionTimeoutMilliSecs;
    private long m_nTimeoutMilliSecs;
    private boolean m_bDebugSMTP;

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sHostName);
        objectOutputStream.writeInt(this.m_nPort);
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sUserName);
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sPassword);
        SerializationConverter.writeConvertedObject(this.m_aCharset, objectOutputStream);
        objectOutputStream.writeBoolean(this.m_bSSLEnabled);
        objectOutputStream.writeBoolean(this.m_bSTARTTLSEnabled);
        objectOutputStream.writeLong(this.m_nConnectionTimeoutMilliSecs);
        objectOutputStream.writeLong(this.m_nTimeoutMilliSecs);
        objectOutputStream.writeBoolean(this.m_bDebugSMTP);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_sHostName = StreamHelper.readSafeUTF(objectInputStream);
        this.m_nPort = objectInputStream.readInt();
        this.m_sUserName = StreamHelper.readSafeUTF(objectInputStream);
        this.m_sPassword = StreamHelper.readSafeUTF(objectInputStream);
        this.m_aCharset = SerializationConverter.readConvertedObject(objectInputStream, Charset.class);
        this.m_bSSLEnabled = objectInputStream.readBoolean();
        this.m_bSTARTTLSEnabled = objectInputStream.readBoolean();
        this.m_nConnectionTimeoutMilliSecs = objectInputStream.readLong();
        this.m_nTimeoutMilliSecs = objectInputStream.readLong();
        this.m_bDebugSMTP = objectInputStream.readBoolean();
    }

    public SMTPSettings(@Nonnull ISMTPSettings iSMTPSettings) {
        this(iSMTPSettings.getHostName(), iSMTPSettings.getPort(), iSMTPSettings.getUserName(), iSMTPSettings.getPassword(), iSMTPSettings.getCharsetObj(), iSMTPSettings.isSSLEnabled(), iSMTPSettings.isSTARTTLSEnabled(), iSMTPSettings.getConnectionTimeoutMilliSecs(), iSMTPSettings.getTimeoutMilliSecs(), iSMTPSettings.isDebugSMTP());
    }

    public SMTPSettings(@Nonnull String string) {
        this(string, -1, null, null, null, EmailGlobalSettings.isUseSSL());
    }

    public SMTPSettings(@Nonnull String string, int n, @Nullable String string2, @Nullable String string3, @Nullable Charset charset, boolean bl) {
        this(string, n, string2, string3, charset, bl, EmailGlobalSettings.isUseSTARTTLS(), EmailGlobalSettings.getConnectionTimeoutMilliSecs(), EmailGlobalSettings.getTimeoutMilliSecs(), EmailGlobalSettings.isDebugSMTP());
    }

    public SMTPSettings(@Nonnull String string, int n, @Nullable String string2, @Nullable String string3, @Nullable Charset charset, boolean bl, boolean bl2, long l, long l2, boolean bl3) {
        this.setHostName(string);
        this.setPort(n);
        this.setUserName(string2);
        this.setPassword(string3);
        this.setCharset(charset != null ? charset : CSMTP.CHARSET_SMTP_OBJ);
        this.setSSLEnabled(bl);
        this.setSTARTTLSEnabled(bl2);
        this.setConnectionTimeoutMilliSecs(l);
        this.setTimeoutMilliSecs(l2);
        this.setDebugSMTP(bl3);
    }

    @Override
    @Nonnull
    public String getHostName() {
        return this.m_sHostName;
    }

    @Nonnull
    public EChange setHostName(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Host");
        if (string.equals(this.m_sHostName)) {
            return EChange.UNCHANGED;
        }
        this.m_sHostName = string;
        return EChange.CHANGED;
    }

    @Override
    public int getPort() {
        return this.m_nPort;
    }

    @Nonnull
    public EChange setPort(int n) {
        if (n != -1 && !NetworkPortHelper.isValidPort(n)) {
            throw new IllegalArgumentException("Port must either be -1 or must be in the valid range!");
        }
        if (n == this.m_nPort) {
            return EChange.UNCHANGED;
        }
        this.m_nPort = n;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getUserName() {
        return this.m_sUserName;
    }

    @Nonnull
    public EChange setUserName(@Nullable String string) {
        String string2;
        String string3 = string2 = StringHelper.hasNoText(string) ? null : string;
        if (EqualsHelper.equals(string2, this.m_sUserName)) {
            return EChange.UNCHANGED;
        }
        this.m_sUserName = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getPassword() {
        return this.m_sPassword;
    }

    @Nonnull
    public EChange setPassword(@Nullable String string) {
        String string2;
        String string3 = string2 = StringHelper.hasNoText(string) ? null : string;
        if (EqualsHelper.equals(string2, this.m_sPassword)) {
            return EChange.UNCHANGED;
        }
        this.m_sPassword = string2;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public Charset getCharsetObj() {
        return this.m_aCharset;
    }

    @Nonnull
    public EChange setCharset(@Nullable Charset charset) {
        if (EqualsHelper.equals(charset, this.m_aCharset)) {
            return EChange.UNCHANGED;
        }
        this.m_aCharset = charset;
        return EChange.CHANGED;
    }

    @Override
    public boolean isSSLEnabled() {
        return this.m_bSSLEnabled;
    }

    @Nonnull
    public EChange setSSLEnabled(boolean bl) {
        if (this.m_bSSLEnabled == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bSSLEnabled = bl;
        return EChange.CHANGED;
    }

    @Override
    public boolean isSTARTTLSEnabled() {
        return this.m_bSTARTTLSEnabled;
    }

    @Nonnull
    public EChange setSTARTTLSEnabled(boolean bl) {
        if (this.m_bSTARTTLSEnabled == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bSTARTTLSEnabled = bl;
        return EChange.CHANGED;
    }

    @Override
    public long getConnectionTimeoutMilliSecs() {
        return this.m_nConnectionTimeoutMilliSecs;
    }

    @Nonnull
    public EChange setConnectionTimeoutMilliSecs(long l) {
        if (this.m_nConnectionTimeoutMilliSecs == l) {
            return EChange.UNCHANGED;
        }
        this.m_nConnectionTimeoutMilliSecs = l;
        return EChange.CHANGED;
    }

    @Override
    public long getTimeoutMilliSecs() {
        return this.m_nTimeoutMilliSecs;
    }

    @Nonnull
    public EChange setTimeoutMilliSecs(long l) {
        if (this.m_nTimeoutMilliSecs == l) {
            return EChange.UNCHANGED;
        }
        this.m_nTimeoutMilliSecs = l;
        return EChange.CHANGED;
    }

    @Override
    public boolean isDebugSMTP() {
        return this.m_bDebugSMTP;
    }

    @Nonnull
    public EChange setDebugSMTP(boolean bl) {
        if (this.m_bDebugSMTP == bl) {
            return EChange.UNCHANGED;
        }
        this.m_bDebugSMTP = bl;
        return EChange.CHANGED;
    }

    @Override
    public boolean areRequiredFieldsSet() {
        return StringHelper.hasText(this.m_sHostName);
    }

    @Override
    @Nonnull
    public SMTPSettings getClone() {
        return new SMTPSettings(this);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SMTPSettings sMTPSettings = (SMTPSettings)object;
        return this.m_sHostName.equals(sMTPSettings.m_sHostName) && this.m_nPort == sMTPSettings.m_nPort && EqualsHelper.equals(this.m_sUserName, sMTPSettings.m_sUserName) && EqualsHelper.equals(this.m_sPassword, sMTPSettings.m_sPassword) && this.m_aCharset.equals(sMTPSettings.m_aCharset) && this.m_bSSLEnabled == sMTPSettings.m_bSSLEnabled && this.m_bSTARTTLSEnabled == sMTPSettings.m_bSTARTTLSEnabled && this.m_nConnectionTimeoutMilliSecs == sMTPSettings.m_nConnectionTimeoutMilliSecs && this.m_nTimeoutMilliSecs == sMTPSettings.m_nTimeoutMilliSecs && this.m_bDebugSMTP == sMTPSettings.m_bDebugSMTP;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sHostName).append(this.m_nPort).append(this.m_sUserName).append(this.m_sPassword).append(this.m_aCharset).append(this.m_bSSLEnabled).append(this.m_bSTARTTLSEnabled).append(this.m_nConnectionTimeoutMilliSecs).append(this.m_nTimeoutMilliSecs).append(this.m_bDebugSMTP).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("hostName", this.m_sHostName).append("port", this.m_nPort).append("userName", this.m_sUserName).appendPassword("password").append("charset", this.m_aCharset).append("SSL", this.m_bSSLEnabled).append("STARTTLS", this.m_bSTARTTLSEnabled).append("connectionTimeout", this.m_nConnectionTimeoutMilliSecs).append("timeout", this.m_nTimeoutMilliSecs).append("debugSMTP", this.m_bDebugSMTP).getToString();
    }
}

