/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.settings;

import com.helger.commons.annotation.ContainsSoftMigration;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.string.StringParser;
import com.helger.smtp.CSMTP;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.settings.SMTPSettings;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SMTPSettingsMicroTypeConverter
implements IMicroTypeConverter<SMTPSettings> {
    private static final String ATTR_HOST = "host";
    private static final String ATTR_PORT = "port";
    private static final String ATTR_USER = "user";
    private static final String ATTR_PASSWORD = "password";
    private static final String ATTR_CHARSET = "charset";
    private static final String ATTR_SSLENABLED = "sslenabled";
    private static final String ATTR_STARTTLSENABLED = "starttlsenabled";
    private static final String ATTR_CONNECTIONTIMEOUT = "connectiontimeout";
    private static final String ATTR_TIMEOUT = "timeout";
    private static final String ATTR_DEBUG_SMTP = "debugsmtp";

    @Nonnull
    public static IMicroElement convertToMicroElementStatic(@Nonnull ISMTPSettings iSMTPSettings, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        microElement.setAttribute(ATTR_HOST, iSMTPSettings.getHostName());
        microElement.setAttribute(ATTR_PORT, iSMTPSettings.getPort());
        microElement.setAttribute(ATTR_USER, iSMTPSettings.getUserName());
        microElement.setAttribute(ATTR_PASSWORD, iSMTPSettings.getPassword());
        microElement.setAttribute(ATTR_CHARSET, iSMTPSettings.getCharsetName());
        microElement.setAttribute(ATTR_SSLENABLED, iSMTPSettings.isSSLEnabled());
        microElement.setAttribute(ATTR_STARTTLSENABLED, iSMTPSettings.isSTARTTLSEnabled());
        microElement.setAttribute(ATTR_CONNECTIONTIMEOUT, iSMTPSettings.getConnectionTimeoutMilliSecs());
        microElement.setAttribute(ATTR_TIMEOUT, iSMTPSettings.getTimeoutMilliSecs());
        microElement.setAttribute(ATTR_DEBUG_SMTP, iSMTPSettings.isDebugSMTP());
        return microElement;
    }

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull SMTPSettings sMTPSettings, @Nullable String string, @Nonnull String string2) {
        return SMTPSettingsMicroTypeConverter.convertToMicroElementStatic(sMTPSettings, string, string2);
    }

    @Nonnull
    public static SMTPSettings convertToSMTPSettings(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_HOST);
        String string2 = iMicroElement.getAttributeValue(ATTR_PORT);
        int n = StringParser.parseInt(string2, CSMTP.DEFAULT_PORT_SMTP);
        String string3 = iMicroElement.getAttributeValue(ATTR_USER);
        String string4 = iMicroElement.getAttributeValue(ATTR_PASSWORD);
        String string5 = iMicroElement.getAttributeValue(ATTR_CHARSET);
        Charset charset = null;
        if (string5 != null) {
            charset = CharsetHelper.getCharsetFromName(string5);
        }
        String string6 = iMicroElement.getAttributeValue(ATTR_SSLENABLED);
        boolean bl = StringParser.parseBool(string6, EmailGlobalSettings.isUseSSL());
        String string7 = iMicroElement.getAttributeValue(ATTR_STARTTLSENABLED);
        boolean bl2 = StringParser.parseBool(string7, EmailGlobalSettings.isUseSTARTTLS());
        String string8 = iMicroElement.getAttributeValue(ATTR_CONNECTIONTIMEOUT);
        long l = StringParser.parseLong(string8, EmailGlobalSettings.getConnectionTimeoutMilliSecs());
        String string9 = iMicroElement.getAttributeValue(ATTR_TIMEOUT);
        long l2 = StringParser.parseLong(string9, EmailGlobalSettings.getTimeoutMilliSecs());
        String string10 = iMicroElement.getAttributeValue(ATTR_DEBUG_SMTP);
        boolean bl3 = StringParser.parseBool(string10, EmailGlobalSettings.isDebugSMTP());
        return new SMTPSettings(string, n, string3, string4, charset, bl, bl2, l, l2, bl3);
    }

    @Override
    @Nonnull
    @ContainsSoftMigration
    public SMTPSettings convertToNative(@Nonnull IMicroElement iMicroElement) {
        return SMTPSettingsMicroTypeConverter.convertToSMTPSettings(iMicroElement);
    }
}

