/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.annotation.Nonempty;
import javax.annotation.Nonnull;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public enum ESMTPTransportProperty {
    USER("user", String.class),
    HOST("host", String.class),
    PORT("port", Integer.TYPE),
    CONNECTIONTIMEOUT("connectiontimeout", Integer.TYPE),
    TIMEOUT("timeout", Integer.TYPE),
    FROM("from", String.class),
    LOCALHOST("localhost", String.class),
    LOCALADDRESS("localaddress", String.class),
    LOCALPORT("localport", Integer.TYPE),
    EHLO("ehlo", Boolean.TYPE),
    AUTH("auth", Boolean.TYPE),
    AUTH_MECHANISMS("auth.mechanisms", String.class),
    AUTH_LOGIN_DISABLE("auth.login.disable", Boolean.TYPE),
    AUTH_PLAIN_DISABLE("auth.plain.disable", Boolean.TYPE),
    AUTH_DIGEST_MD5_DISABLE("auth.digest-md5.disable", Boolean.TYPE),
    AUTH_NTLM_DISABLE("auth.ntlm.disable", Boolean.TYPE),
    AUTH_NTLM_DOMAIN("auth.ntlm.domain", String.class),
    AUTH_NTLM_FLAGS("auth.ntlm.flags", Integer.TYPE),
    SUBMITTER("submitter", String.class),
    DSN_NOTIFY("dsn.notify", String.class),
    DSN_RET("dsn.ret", String.class),
    ALLOW8BITMIME("allow8bitmime", Boolean.TYPE),
    SENDPARTIAL("sendpartial", Boolean.TYPE),
    SASL_ENABLE("sasl.enable", Boolean.TYPE),
    SASL_MECHANISMS("sasl.mechanisms", String.class),
    SASL_AUTHORIZATIONID("sasl.authorizationid", String.class),
    SASL_REALM("sasl.realm", String.class),
    QUITWAIT("quitwait", Boolean.TYPE),
    REPORTSUCCESS("reportsuccess", Boolean.TYPE),
    SOCKETFACTORY("socketFactory", SocketFactory.class),
    SOCKETFACTORY_CLASS("socketFactory.class", String.class),
    SOCKETFACTORY_FALLBACK("socketFactory.fallback", Boolean.TYPE),
    SOCKETFACTORY_PORT("socketFactory.port", Integer.TYPE),
    SSL_ENABLE("ssl.enable", Boolean.TYPE),
    SSL_CHECKSERVERIDENTITY("ssl.checkserveridentity", Boolean.TYPE),
    SSL_TRUST("ssl.trust", String.class),
    SSL_SOCKETFACTORY("ssl.socketFactory", SSLSocketFactory.class),
    SSL_SOCKETFACTORY_CLASS("ssl.socketFactory.class", String.class),
    SSL_SOCKETFACTORY_PORT("ssl.socketFactory.port", Integer.TYPE),
    SSL_PROTOCOLS("ssl.protocols", String.class),
    SSL_CIPHERSUITES("ssl.ciphersuites", String.class),
    STARTTLS_ENABLE("starttls.enable", Boolean.TYPE),
    STARTTLS_REQUIRED("starttls.required", Boolean.TYPE),
    SOCKS_HOST("socks.host", String.class),
    SOCKS_PORT("socks.port", String.class),
    MAILEXTENSION("mailextension", String.class),
    USERSET("userset", Boolean.TYPE),
    NOOP_STRICT("noop.strict", Boolean.TYPE);

    public static final String PREFIX_MAIL_SMTP = "mail.smtp.";
    public static final String PREFIX_MAIL_SMTPS = "mail.smtps.";
    private final String m_sPropertyName;
    private final Class<?> m_aPropertyValueClass;

    private ESMTPTransportProperty(String string2, Class<?> clazz) {
        this.m_sPropertyName = string2;
        this.m_aPropertyValueClass = clazz;
    }

    @Nonnull
    @Nonempty
    public String getSMTPPropertyName() {
        return PREFIX_MAIL_SMTP + this.m_sPropertyName;
    }

    @Nonnull
    @Nonempty
    public String getSMTPSPropertyName() {
        return PREFIX_MAIL_SMTPS + this.m_sPropertyName;
    }

    @Nonnull
    @Nonempty
    public String getPropertyName(boolean bl) {
        return bl ? this.getSMTPSPropertyName() : this.getSMTPPropertyName();
    }

    @Nonnull
    public Class<?> getPropertyValueClass() {
        return this.m_aPropertyValueClass;
    }
}

