/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ELockType;
import com.helger.commons.annotation.MustBeLocked;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.email.IEmailAddress;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.StringHelper;
import com.helger.commons.vendor.VendorInfo;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailQueuePerSMTP;
import com.helger.smtp.transport.MailSendException;
import com.helger.smtp.transport.MailTransportError;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MailAPI {
    public static final String DEBUG_SUBJECT_PREFIX = "[DEBUG] ";
    public static final String DEFAULT_SUBJECT = "<no subject specified>";
    public static final boolean DEFAULT_STOP_IMMEDIATLY = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(MailAPI.class);
    private static final IMutableStatisticsHandlerCounter s_aQueuedMailHdl = StatisticsManager.getCounterHandler(MailAPI.class.getName() + "$mails.queued");
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    private static final ICommonsMap<ISMTPSettings, MailQueuePerSMTP> s_aQueueCache = new CommonsHashMap<ISMTPSettings, MailQueuePerSMTP>();
    private static final ThreadFactory s_aThreadFactory = new BasicThreadFactory.Builder().setNamingPattern("MailAPI-%d").setDaemon(true).setPriority(5).build();
    private static final ExecutorService s_aSenderThreadPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), s_aThreadFactory);
    @GuardedBy(value="s_aRWLock")
    private static FailedMailQueue s_aFailedMailQueue = new FailedMailQueue();

    private MailAPI() {
    }

    @Nonnull
    public static FailedMailQueue getFailedMailQueue() {
        return s_aRWLock.readLockedGet(() -> s_aFailedMailQueue);
    }

    public static void setFailedMailQueue(@Nonnull FailedMailQueue failedMailQueue) {
        ValueEnforcer.notNull(failedMailQueue, "FailedMailQueue");
        s_aRWLock.writeLocked(() -> {
            s_aFailedMailQueue = failedMailQueue;
            for (MailQueuePerSMTP mailQueuePerSMTP : s_aQueueCache.values()) {
                mailQueuePerSMTP.setFailedMailQueue(failedMailQueue);
            }
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Set FailedMailQueue to " + failedMailQueue);
        }
    }

    @Nonnull
    @MustBeLocked(value=ELockType.WRITE)
    private static MailQueuePerSMTP _getOrCreateMailQueuePerSMTP(@Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notNull(iSMTPSettings, "SmtpSettings");
        if (s_aSenderThreadPool.isShutdown()) {
            throw new IllegalStateException("Cannot submit to mailqueues that are already stopped!");
        }
        MailQueuePerSMTP mailQueuePerSMTP = (MailQueuePerSMTP)s_aQueueCache.get(iSMTPSettings);
        if (mailQueuePerSMTP == null) {
            mailQueuePerSMTP = new MailQueuePerSMTP(EmailGlobalSettings.getMaxMailQueueLength(), EmailGlobalSettings.getMaxMailSendCount(), iSMTPSettings, s_aFailedMailQueue);
            s_aQueueCache.put(iSMTPSettings, mailQueuePerSMTP);
            s_aSenderThreadPool.submit(mailQueuePerSMTP::collect);
        }
        return mailQueuePerSMTP;
    }

    public static boolean hasNonVendorEmailAddress(@Nullable Iterable<? extends IEmailAddress> iterable) {
        if (iterable != null) {
            String string = VendorInfo.getVendorEmailSuffix();
            for (IEmailAddress iEmailAddress : iterable) {
                if (iEmailAddress.getAddress().endsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static ESuccess queueMail(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull IMutableEmailData iMutableEmailData) {
        int n = MailAPI.queueMails(iSMTPSettings, new CommonsArrayList<IMutableEmailData>(iMutableEmailData));
        return ESuccess.valueOf(n == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnegative
    public static int queueMails(@Nonnull ISMTPSettings iSMTPSettings, @Nonnull Collection<? extends IMutableEmailData> collection) {
        MailQueuePerSMTP mailQueuePerSMTP;
        ValueEnforcer.notNull(iSMTPSettings, "SmtpSettings");
        ValueEnforcer.notNull(collection, "MailDataList");
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("At least one message has to be supplied!");
        }
        s_aRWLock.writeLock().lock();
        try {
            try {
                mailQueuePerSMTP = MailAPI._getOrCreateMailQueuePerSMTP(iSMTPSettings);
            }
            catch (IllegalStateException illegalStateException) {
                MailTransportError mailTransportError = new MailTransportError(illegalStateException);
                for (IMutableEmailData iMutableEmailData : collection) {
                    MailAPI.getFailedMailQueue().add(new FailedMailData(iSMTPSettings, iMutableEmailData, mailTransportError));
                }
                int n = 0;
                s_aRWLock.writeLock().unlock();
                return n;
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
        int n = 0;
        boolean bl = GlobalDebug.isDebugMode();
        for (IMutableEmailData iMutableEmailData : collection) {
            if (iMutableEmailData == null) {
                LOGGER.error("Mail data is null! Ignoring this item completely.");
                continue;
            }
            s_aQueuedMailHdl.increment();
            boolean bl2 = true;
            if (iMutableEmailData.getFrom() == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Mail data has no sender address: " + iMutableEmailData + " - not queuing!");
                }
                bl2 = false;
            }
            if (iMutableEmailData.to().isEmpty()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Mail data has no receiver address: " + iMutableEmailData + " - not queuing!");
                }
                bl2 = false;
            }
            if (bl && (MailAPI.hasNonVendorEmailAddress(iMutableEmailData.to()) || MailAPI.hasNonVendorEmailAddress(iMutableEmailData.cc()) || MailAPI.hasNonVendorEmailAddress(iMutableEmailData.bcc()))) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Debug mode: ignoring mail TO '" + iMutableEmailData.to() + "'" + (iMutableEmailData.cc().isNotEmpty() ? " and CC '" + iMutableEmailData.cc() + "'" : "") + (iMutableEmailData.bcc().isNotEmpty() ? " and BCC '" + iMutableEmailData.bcc() + "'" : "") + " because at least one address is not targeted to the vendor domain '" + VendorInfo.getVendorEmailSuffix() + "'");
                }
                bl2 = false;
            }
            if (mailQueuePerSMTP.isStopped()) {
                LOGGER.error("Queue is already stopped - not queuing!");
                bl2 = false;
            }
            boolean bl3 = false;
            Exception exception = null;
            if (bl2) {
                if (StringHelper.hasNoText(iMutableEmailData.getSubject())) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Mail data has no subject: " + iMutableEmailData + " - defaulting to " + DEFAULT_SUBJECT);
                    }
                    iMutableEmailData.setSubject(DEFAULT_SUBJECT);
                }
                if (StringHelper.hasNoText(iMutableEmailData.getBody()) && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Mail data has no body: " + iMutableEmailData);
                }
                if (bl) {
                    if (!StringHelper.startsWith(iMutableEmailData.getSubject(), DEBUG_SUBJECT_PREFIX)) {
                        iMutableEmailData.setSubject(DEBUG_SUBJECT_PREFIX + iMutableEmailData.getSubject());
                    }
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Sending only-to-vendor mail in debug version:\n" + iSMTPSettings + "\n" + iMutableEmailData);
                    }
                }
                iMutableEmailData.setSentDateTime(PDTFactory.getCurrentLocalDateTime());
                try {
                    if (mailQueuePerSMTP.queueObject(iMutableEmailData).isSuccess()) {
                        bl3 = true;
                        ++n;
                    }
                }
                catch (Exception exception2) {
                    exception = exception2;
                }
            } else {
                exception = new MailSendException("Email cannot be queued because internal constraints are not fulfilled!");
            }
            if (bl3) continue;
            mailQueuePerSMTP.getFailedMailQueue().add(new FailedMailData(iSMTPSettings, iMutableEmailData, new MailTransportError(exception)));
        }
        return n;
    }

    @Nonnegative
    @MustBeLocked(value=ELockType.READ)
    private static int _getTotalQueueLength() {
        int n = 0;
        for (MailQueuePerSMTP mailQueuePerSMTP : s_aQueueCache.values()) {
            n += mailQueuePerSMTP.getQueueLength();
        }
        return n;
    }

    @Nonnegative
    public static int getTotalQueueLength() {
        return s_aRWLock.readLockedInt(MailAPI::_getTotalQueueLength);
    }

    @Nonnull
    public static EChange stop() {
        return MailAPI.stop(false);
    }

    @Nonnull
    public static EChange stop(boolean bl) {
        s_aRWLock.writeLock().lock();
        try {
            if (s_aSenderThreadPool.isShutdown()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            s_aSenderThreadPool.shutdown();
            for (MailQueuePerSMTP mailQueuePerSMTP : s_aQueueCache.values()) {
                mailQueuePerSMTP.stopQueuingNewObjects(bl);
            }
            int n = s_aQueueCache.size();
            int n2 = MailAPI._getTotalQueueLength() - 1;
            if ((n > 0 || n2 > 0) && LOGGER.isInfoEnabled()) {
                LOGGER.info("Stopping central mail queues: " + n + " queue" + (n == 1 ? "" : "s") + " with " + n2 + " mail" + (n2 == 1 ? "" : "s"));
            }
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
        try {
            while (!s_aSenderThreadPool.awaitTermination(1L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error("Error stopping mail queue", interruptedException);
            Thread.currentThread().interrupt();
        }
        return EChange.CHANGED;
    }
}

