/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.typeconvert.TypeConverter;
import com.helger.mail.address.InternetAddressHelper;
import com.helger.smtp.data.IEmailAttachmentDataSource;
import com.helger.smtp.data.IMutableEmailData;
import java.nio.charset.Charset;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

@Immutable
public final class MailConverter {
    private MailConverter() {
    }

    public static void setSubject(@Nonnull MimeMessage mimeMessage, @Nonnull String string, @Nonnull Charset charset) {
        try {
            mimeMessage.setSubject(string, charset.name());
        }
        catch (MessagingException messagingException) {
            throw new IllegalStateException("Charset " + charset + " is unknown!", messagingException);
        }
    }

    public static void setText(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull String string, @Nonnull Charset charset) {
        try {
            mimeBodyPart.setText(string, charset.name());
        }
        catch (MessagingException messagingException) {
            throw new IllegalStateException("Charset " + charset + " is unknown!", messagingException);
        }
    }

    public static void fillMimeMessageUnsafe(@Nonnull MimeMessage mimeMessage, @Nonnull IMutableEmailData iMutableEmailData, @Nullable Charset charset) throws MessagingException {
        if (iMutableEmailData.getFrom() != null) {
            mimeMessage.setFrom(InternetAddressHelper.getAsInternetAddress(iMutableEmailData.getFrom(), charset));
        }
        mimeMessage.setReplyTo(InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.replyTo(), charset));
        mimeMessage.setRecipients(Message.RecipientType.TO, InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.to(), charset));
        mimeMessage.setRecipients(Message.RecipientType.CC, InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.cc(), charset));
        mimeMessage.setRecipients(Message.RecipientType.BCC, InternetAddressHelper.getAsInternetAddressArray(iMutableEmailData.bcc(), charset));
        if (iMutableEmailData.getSentDateTime() != null) {
            mimeMessage.setSentDate(TypeConverter.convert(iMutableEmailData.getSentDateTime(), Date.class));
        }
        if (iMutableEmailData.getSubject() != null) {
            if (charset != null) {
                MailConverter.setSubject(mimeMessage, iMutableEmailData.getSubject(), charset);
            } else {
                mimeMessage.setSubject(iMutableEmailData.getSubject());
            }
        }
        MimeMultipart mimeMultipart = new MimeMultipart();
        Object object = new MimeBodyPart();
        if (iMutableEmailData.getEmailType().isHTML()) {
            if (charset != null) {
                ((MimeBodyPart)object).setContent(iMutableEmailData.getBody(), new MimeType(CMimeType.TEXT_HTML).addParameter("charset", charset.name()).getAsString());
            } else {
                ((MimeBodyPart)object).setContent(iMutableEmailData.getBody(), CMimeType.TEXT_HTML.getAsString());
            }
        } else if (charset != null) {
            MailConverter.setText((MimeBodyPart)object, iMutableEmailData.getBody(), charset);
        } else {
            ((MimeBodyPart)object).setText(iMutableEmailData.getBody());
        }
        mimeMultipart.addBodyPart((BodyPart)object);
        object = iMutableEmailData.getAttachments();
        if (object != null) {
            for (IEmailAttachmentDataSource iEmailAttachmentDataSource : object.getAsDataSourceList()) {
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                mimeBodyPart.setDisposition(iEmailAttachmentDataSource.getDisposition().getID());
                mimeBodyPart.setFileName(iEmailAttachmentDataSource.getName());
                mimeBodyPart.setDataHandler(iEmailAttachmentDataSource.getAsDataHandler());
                mimeMultipart.addBodyPart(mimeBodyPart);
            }
        }
        mimeMessage.setContent(mimeMultipart);
    }

    public static void fillMimeMessage(@Nonnull MimeMessage mimeMessage, @Nonnull IMutableEmailData iMutableEmailData, @Nullable Charset charset) {
        try {
            MailConverter.fillMimeMessageUnsafe(mimeMessage, iMutableEmailData, charset);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

