/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.concurrent.collector.ConcurrentCollectorMultiple;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.state.ESuccess;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.failed.FailedMailData;
import com.helger.smtp.failed.FailedMailQueue;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.MailTransport;
import com.helger.smtp.transport.MailTransportError;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MailQueuePerSMTP
extends ConcurrentCollectorMultiple<IMutableEmailData>
implements IConcurrentPerformer<List<IMutableEmailData>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailQueuePerSMTP.class);
    private final MailTransport m_aTransport;
    private FailedMailQueue m_aFailedMailQueue;

    public MailQueuePerSMTP(@Nonnegative int n, @Nonnegative int n2, @Nonnull ISMTPSettings iSMTPSettings, @Nonnull FailedMailQueue failedMailQueue) {
        super(n, n2);
        ValueEnforcer.notNull(iSMTPSettings, "SMTPSettings");
        this.m_aTransport = new MailTransport(iSMTPSettings);
        this.setFailedMailQueue(failedMailQueue);
        this.setPerformer(this);
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aTransport.getSMTPSettings();
    }

    @Nonnull
    public FailedMailQueue getFailedMailQueue() {
        return this.m_aFailedMailQueue;
    }

    @Nonnull
    public MailQueuePerSMTP setFailedMailQueue(@Nonnull FailedMailQueue failedMailQueue) {
        this.m_aFailedMailQueue = ValueEnforcer.notNull(failedMailQueue, "FailedMailQueue");
        return this;
    }

    @Override
    public void runAsync(@Nullable List<IMutableEmailData> list) {
        if (CollectionHelper.isNotEmpty(list)) {
            ISMTPSettings iSMTPSettings = this.m_aTransport.getSMTPSettings();
            try {
                int n = list.size();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Sending " + n + " mail message" + (n == 1 ? "" : "s") + "!");
                }
                ICommonsOrderedMap<IMutableEmailData, MailTransportError> iCommonsOrderedMap = this.m_aTransport.send(list);
                for (Map.Entry entry : iCommonsOrderedMap.entrySet()) {
                    this.m_aFailedMailQueue.add(new FailedMailData(iSMTPSettings, (IMutableEmailData)entry.getKey(), (MailTransportError)entry.getValue()));
                }
            }
            catch (Exception exception) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Generic error sending mail: " + exception.getMessage(), exception.getCause());
                }
                MailTransportError mailTransportError = new MailTransportError(exception);
                for (IMutableEmailData iMutableEmailData : list) {
                    this.m_aFailedMailQueue.add(new FailedMailData(iSMTPSettings, iMutableEmailData, mailTransportError));
                }
            }
        }
    }

    @Nonnull
    public ESuccess stopQueuingNewObjects(boolean bl) {
        if (bl) {
            CommonsArrayList commonsArrayList = new CommonsArrayList();
            this.m_aQueue.drainTo(commonsArrayList);
            if (!commonsArrayList.isEmpty()) {
                ISMTPSettings iSMTPSettings = this.getSMTPSettings();
                for (Object e : commonsArrayList) {
                    this.m_aFailedMailQueue.add(new FailedMailData(iSMTPSettings, (IMutableEmailData)e));
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Put " + commonsArrayList + " unsent mails into the failed mail queue because of immediate stop.");
                }
            }
        }
        return super.stopQueuingNewObjects();
    }
}

