/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.transport.ESMTPErrorCode;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MailSendDetails
implements Serializable {
    private final boolean m_bAddressValid;
    private final String m_sAddress;
    private final String m_sCommand;
    private final String m_sErrorMessage;
    private final ESMTPErrorCode m_eErrorCode;

    public MailSendDetails(boolean bl, @Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nonnull ESMTPErrorCode eSMTPErrorCode) {
        this.m_bAddressValid = bl;
        this.m_sAddress = ValueEnforcer.notNull(string, "Address");
        this.m_sCommand = ValueEnforcer.notNull(string2, "Command");
        this.m_sErrorMessage = ValueEnforcer.notNull(string3, "ErrorMessage");
        this.m_eErrorCode = ValueEnforcer.notNull(eSMTPErrorCode, "ErrorCode");
    }

    public boolean isAddressValid() {
        return this.m_bAddressValid;
    }

    @Nonnull
    public String getAddress() {
        return this.m_sAddress;
    }

    @Nonnull
    public String getCommand() {
        return this.m_sCommand;
    }

    @Nonnull
    public String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    @Nonnull
    public ESMTPErrorCode getErrorCode() {
        return this.m_eErrorCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("AddressValid", this.m_bAddressValid).append("Address", this.m_sAddress).append("Command", this.m_sCommand).append("ErrorMessage", this.m_sErrorMessage).append("ErrorCode", this.m_eErrorCode).getToString();
    }
}

