/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.network.WebExceptionHelper;
import com.helger.smtp.EmailGlobalSettings;
import com.helger.smtp.data.IMutableEmailData;
import com.helger.smtp.listener.EmailDataTransportEvent;
import com.helger.smtp.listener.IEmailDataTransportListener;
import com.helger.smtp.settings.ISMTPSettings;
import com.helger.smtp.transport.ESMTPErrorCode;
import com.helger.smtp.transport.ESMTPTransportProperty;
import com.helger.smtp.transport.MailConverter;
import com.helger.smtp.transport.MailSendDetails;
import com.helger.smtp.transport.MailSendException;
import com.helger.smtp.transport.MailTransportError;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.ConnectionListener;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MailTransport {
    public static final String SMTP_PROTOCOL = "smtp";
    public static final String SMTPS_PROTOCOL = "smtps";
    public static final String X_MAILER = "ph-smtp";
    private static final IMutableStatisticsHandlerCounter s_aStatsCountSuccess = StatisticsManager.getCounterHandler(MailTransport.class.getName() + "$success");
    private static final IMutableStatisticsHandlerCounter s_aStatsCountFailed = StatisticsManager.getCounterHandler(MailTransport.class.getName() + "$failed");
    private static final Logger LOGGER = LoggerFactory.getLogger(MailTransport.class);
    private static final String HEADER_MESSAGE_ID = "Message-ID";
    private final ISMTPSettings m_aSMTPSettings;
    private final boolean m_bSMTPS;
    private final ICommonsMap<String, String> m_aMailProperties;
    private final Session m_aSession;

    public static boolean isUseSMTPS(@Nonnull ISMTPSettings iSMTPSettings) {
        return iSMTPSettings.isSSLEnabled() || iSMTPSettings.isSTARTTLSEnabled();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsMap<String, String> createSessionProperties(@Nonnull ISMTPSettings iSMTPSettings) {
        long l;
        long l2;
        CommonsHashMap<String, String> commonsHashMap = new CommonsHashMap<String, String>();
        boolean bl = MailTransport.isUseSMTPS(iSMTPSettings);
        if (iSMTPSettings.isSSLEnabled()) {
            commonsHashMap.put(ESMTPTransportProperty.SSL_ENABLE.getPropertyName(bl), Boolean.TRUE.toString());
        }
        if (iSMTPSettings.hasUserName()) {
            commonsHashMap.put(ESMTPTransportProperty.AUTH.getPropertyName(bl), Boolean.TRUE.toString());
        }
        if (iSMTPSettings.isSTARTTLSEnabled()) {
            commonsHashMap.put(ESMTPTransportProperty.STARTTLS_ENABLE.getPropertyName(bl), Boolean.TRUE.toString());
        }
        if ((l2 = iSMTPSettings.getConnectionTimeoutMilliSecs()) > 0L) {
            commonsHashMap.put(ESMTPTransportProperty.CONNECTIONTIMEOUT.getPropertyName(bl), Long.toString(l2));
        }
        if ((l = iSMTPSettings.getTimeoutMilliSecs()) > 0L) {
            commonsHashMap.put(ESMTPTransportProperty.TIMEOUT.getPropertyName(bl), Long.toString(l));
        }
        commonsHashMap.put(ESMTPTransportProperty.REPORTSUCCESS.getPropertyName(bl), Boolean.toString(true));
        commonsHashMap.put(ESMTPTransportProperty.SENDPARTIAL.getPropertyName(bl), Boolean.toString(false));
        commonsHashMap.put("mail.debug", Boolean.toString(iSMTPSettings.isDebugSMTP()));
        commonsHashMap.put("mail.debug.auth", Boolean.toString(iSMTPSettings.isDebugSMTP()));
        return commonsHashMap;
    }

    public MailTransport(@Nonnull ISMTPSettings iSMTPSettings) {
        ValueEnforcer.notNull(iSMTPSettings, "Settings");
        this.m_aSMTPSettings = iSMTPSettings;
        this.m_bSMTPS = MailTransport.isUseSMTPS(iSMTPSettings);
        this.m_aMailProperties = MailTransport.createSessionProperties(iSMTPSettings);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Mail properties: " + this.m_aMailProperties);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.m_aMailProperties);
        this.m_aSession = Session.getInstance(properties);
    }

    @Nonnull
    public ISMTPSettings getSMTPSettings() {
        return this.m_aSMTPSettings;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getMailProperties() {
        return (ICommonsMap)this.m_aMailProperties.getClone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ICommonsOrderedMap<IMutableEmailData, MailTransportError> send(@Nullable Collection<IMutableEmailData> collection) {
        CommonsLinkedHashMap<IMutableEmailData, MailTransportError> commonsLinkedHashMap;
        block47: {
            commonsLinkedHashMap = new CommonsLinkedHashMap<IMutableEmailData, MailTransportError>();
            if (collection != null) {
                CommonsArrayList<Collection<IMutableEmailData>> commonsArrayList = new CommonsArrayList<Collection<IMutableEmailData>>(collection);
                MailSendException mailSendException = null;
                try {
                    Throwable serializable = null;
                    try (Transport transport = this.m_aSession.getTransport(this.m_bSMTPS ? SMTPS_PROTOCOL : SMTP_PROTOCOL);){
                        for (ConnectionListener connectionListener : EmailGlobalSettings.getAllConnectionListeners()) {
                            transport.addConnectionListener(connectionListener);
                        }
                        ICommonsList<IEmailDataTransportListener> iCommonsList = EmailGlobalSettings.getAllEmailDataTransportListeners();
                        transport.connect(this.m_aSMTPSettings.getHostName(), this.m_aSMTPSettings.getPort(), this.m_aSMTPSettings.getUserName(), this.m_aSMTPSettings.getPassword());
                        for (IMutableEmailData iMutableEmailData : collection) {
                            Serializable serializable2;
                            Object object;
                            Object object2;
                            Object object3;
                            CommonsLinkedHashSet<MailSendDetails> commonsLinkedHashSet;
                            MimeMessage mimeMessage = new MimeMessage(this.m_aSession);
                            try {
                                MailConverter.fillMimeMessage(mimeMessage, iMutableEmailData, this.m_aSMTPSettings.getCharsetObj());
                                if (mimeMessage.getSentDate() == null) {
                                    mimeMessage.setSentDate(new Date());
                                }
                                String string = mimeMessage.getMessageID();
                                mimeMessage.saveChanges();
                                if (string != null) {
                                    mimeMessage.setHeader(HEADER_MESSAGE_ID, string);
                                }
                                mimeMessage.setHeader("X-Mailer", X_MAILER);
                                if (LOGGER.isInfoEnabled()) {
                                    LOGGER.info("Delivering mail from " + Arrays.toString(mimeMessage.getFrom()) + " to " + Arrays.toString(mimeMessage.getAllRecipients()) + " with subject '" + mimeMessage.getSubject() + "' and message ID '" + mimeMessage.getMessageID() + "'");
                                }
                                transport.sendMessage(mimeMessage, mimeMessage.getAllRecipients());
                                throw new IllegalStateException("Never expected to come beyong sendMessage!");
                            }
                            catch (SendFailedException sendFailedException) {
                                Object object4;
                                Object object5;
                                Serializable serializable3;
                                if (EmailGlobalSettings.isDebugSMTP()) {
                                    LOGGER.error("Error send mail - SendFailedException", sendFailedException);
                                }
                                commonsLinkedHashSet = CollectionHelper.newSetMapped(sendFailedException.getValidSentAddresses(), Address::toString);
                                object3 = CollectionHelper.newSetMapped(sendFailedException.getValidUnsentAddresses(), Address::toString);
                                object2 = CollectionHelper.newSetMapped(sendFailedException.getInvalidAddresses(), Address::toString);
                                object = new CommonsArrayList();
                                MessagingException messagingException = sendFailedException;
                                while ((serializable2 = messagingException.getNextException()) != null && serializable2 instanceof MessagingException) {
                                    if (serializable2 instanceof SMTPAddressFailedException) {
                                        serializable3 = (SMTPAddressFailedException)serializable2;
                                        object.add(new MailSendDetails(false, ((SMTPAddressFailedException)serializable3).getAddress().toString(), ((SMTPAddressFailedException)serializable3).getCommand(), ((Throwable)serializable3).getMessage().trim(), ESMTPErrorCode.getFromIDOrDefault(((SMTPAddressFailedException)serializable3).getReturnCode(), ESMTPErrorCode.FALLBACK)));
                                    } else if (serializable2 instanceof SMTPAddressSucceededException) {
                                        serializable3 = (SMTPAddressSucceededException)serializable2;
                                        object.add(new MailSendDetails(true, ((SMTPAddressSucceededException)serializable3).getAddress().toString(), ((SMTPAddressSucceededException)serializable3).getCommand(), ((Throwable)serializable3).getMessage().trim(), ESMTPErrorCode.getFromIDOrDefault(((SMTPAddressSucceededException)serializable3).getReturnCode(), ESMTPErrorCode.FALLBACK)));
                                    }
                                    messagingException = (MessagingException)serializable2;
                                }
                                serializable3 = new CommonsLinkedHashSet();
                                CommonsLinkedHashSet<MailSendDetails> commonsLinkedHashSet2 = new CommonsLinkedHashSet<MailSendDetails>();
                                CommonsLinkedHashSet<MailSendDetails> commonsLinkedHashSet3 = new CommonsLinkedHashSet<MailSendDetails>();
                                Object object6 = object.iterator();
                                while (object6.hasNext()) {
                                    object5 = (MailSendDetails)object6.next();
                                    object4 = ((MailSendDetails)object5).getAddress();
                                    if (commonsLinkedHashSet.contains(object4)) {
                                        serializable3.add(object5);
                                        continue;
                                    }
                                    if (object3.contains(object4)) {
                                        commonsLinkedHashSet2.add(object5);
                                        continue;
                                    }
                                    commonsLinkedHashSet3.add(object5);
                                }
                                object6 = new EmailDataTransportEvent(this.m_aSMTPSettings, iMutableEmailData, mimeMessage, (Collection<MailSendDetails>)((Object)serializable3), commonsLinkedHashSet2, commonsLinkedHashSet3);
                                if (object3.isEmpty() && object2.isEmpty() && commonsLinkedHashSet.isNotEmpty()) {
                                    object5 = iCommonsList.iterator();
                                    while (object5.hasNext()) {
                                        object4 = (IEmailDataTransportListener)object5.next();
                                        object4.messageDelivered((EmailDataTransportEvent)object6);
                                    }
                                    s_aStatsCountSuccess.increment();
                                } else {
                                    object5 = iCommonsList.iterator();
                                    while (object5.hasNext()) {
                                        object4 = (IEmailDataTransportListener)object5.next();
                                        object4.messageNotDelivered((EmailDataTransportEvent)object6);
                                    }
                                    commonsLinkedHashMap.put(iMutableEmailData, new MailTransportError(sendFailedException, (Iterable<? extends MailSendDetails>)object));
                                    s_aStatsCountFailed.increment();
                                }
                                commonsArrayList.remove(iMutableEmailData);
                            }
                            catch (MessagingException messagingException) {
                                if (EmailGlobalSettings.isDebugSMTP()) {
                                    LOGGER.error("Error send mail - MessagingException", messagingException);
                                }
                                commonsLinkedHashSet = new CommonsLinkedHashSet();
                                object3 = iEmailAddress -> commonsLinkedHashSet.add(new MailSendDetails(false, iEmailAddress.getAddress(), "<generic error>", messagingException.getMessage(), ESMTPErrorCode.FALLBACK));
                                iMutableEmailData.to().forEach(object3);
                                iMutableEmailData.cc().forEach(object3);
                                iMutableEmailData.bcc().forEach(object3);
                                object2 = new EmailDataTransportEvent(this.m_aSMTPSettings, iMutableEmailData, mimeMessage, new CommonsArrayList<MailSendDetails>(), new CommonsArrayList<MailSendDetails>(), commonsLinkedHashSet);
                                object = iCommonsList.iterator();
                                while (object.hasNext()) {
                                    serializable2 = (IEmailDataTransportListener)object.next();
                                    serializable2.messageNotDelivered((EmailDataTransportEvent)object2);
                                }
                                commonsLinkedHashMap.put(iMutableEmailData, new MailTransportError(messagingException));
                                commonsArrayList.remove(iMutableEmailData);
                                s_aStatsCountFailed.increment();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable iMutableEmailData = throwable;
                        throw throwable;
                    }
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    mailSendException = new MailSendException("Mail server authentication failed", authenticationFailedException);
                    return mailSendException;
                }
                catch (MessagingException messagingException) {
                    if (WebExceptionHelper.isServerNotReachableConnection(messagingException.getCause())) {
                        mailSendException = new MailSendException("Failed to connect to mail server: " + messagingException.getCause().getMessage());
                    }
                    mailSendException = new MailSendException("Mail server connection failed", messagingException);
                    return mailSendException;
                }
                catch (Exception exception) {
                    mailSendException = new MailSendException("Internal error sending mail", exception);
                    return mailSendException;
                }
                finally {
                    if (!commonsArrayList.isNotEmpty()) break block47;
                    if (mailSendException == null) {
                        mailSendException = new MailSendException("Internal error - messages are remaining but no Exception occurred!");
                    }
                    for (IMutableEmailData iMutableEmailData : commonsArrayList) {
                        commonsLinkedHashMap.put(iMutableEmailData, new MailTransportError(mailSendException));
                    }
                }
            }
        }
        return commonsLinkedHashMap;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MailTransport mailTransport = (MailTransport)object;
        return this.m_aSMTPSettings.equals(mailTransport.m_aSMTPSettings);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aSMTPSettings).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("settings", this.m_aSMTPSettings).append("properties", this.m_aMailProperties).append("session", this.m_aSession).getToString();
    }
}

