/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport.listener;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.ICallback;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.log.LogHelper;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConnectionListener
implements ConnectionListener,
ICallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConnectionListener.class);
    private final IErrorLevel m_aErrorLevel;

    public LoggingConnectionListener() {
        this(EErrorLevel.INFO);
    }

    public LoggingConnectionListener(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
    }

    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Override
    public void opened(@Nonnull ConnectionEvent connectionEvent) {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Connected to SMTP server");
    }

    @Override
    public void disconnected(@Nonnull ConnectionEvent connectionEvent) {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Disconnected from SMTP server");
    }

    @Override
    public void closed(@Nonnull ConnectionEvent connectionEvent) {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Closed connection to SMTP server");
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

