/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.transport.listener;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.log.LogHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.smtp.listener.EmailDataTransportEvent;
import com.helger.smtp.listener.IEmailDataTransportListener;
import com.helger.smtp.transport.MailSendDetails;
import com.helger.smtp.transport.listener.LoggingConnectionListener;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTransportListener
implements IEmailDataTransportListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConnectionListener.class);
    private final IErrorLevel m_aErrorLevel;

    public LoggingTransportListener() {
        this(EErrorLevel.INFO);
    }

    public LoggingTransportListener(@Nonnull IErrorLevel iErrorLevel) {
        this.m_aErrorLevel = ValueEnforcer.notNull(iErrorLevel, "ErrorLevel");
    }

    @Nonnull
    public IErrorLevel getErrorLevel() {
        return this.m_aErrorLevel;
    }

    @Nonnull
    public static String getAddressesString(@Nullable Collection<? extends MailSendDetails> collection) {
        if (collection == null || collection.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder().append('[');
        for (MailSendDetails mailSendDetails : collection) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(mailSendDetails.getAddress());
            if (mailSendDetails.isAddressValid()) continue;
            stringBuilder.append(" (").append(mailSendDetails.getErrorMessage()).append(')');
        }
        return stringBuilder.append(']').toString();
    }

    @Nonnull
    public static String getMessageString(@Nullable Message message) {
        if (message == null) {
            return "null";
        }
        if (message instanceof MimeMessage) {
            try {
                return "MIME-Msg " + ((MimeMessage)message).getMessageID();
            }
            catch (MessagingException messagingException) {
                return "MIME-Msg " + messagingException.getClass().getName() + " - " + messagingException.getMessage();
            }
        }
        return ClassHelper.getClassLocalName(message.getClass());
    }

    @Nonnull
    public static String getLogString(@Nonnull EmailDataTransportEvent emailDataTransportEvent) {
        return "validSent=" + LoggingTransportListener.getAddressesString(emailDataTransportEvent.getValidSentAddresses()) + "; validUnsent=" + LoggingTransportListener.getAddressesString(emailDataTransportEvent.getValidUnsentAddresses()) + "; invalid=" + LoggingTransportListener.getAddressesString(emailDataTransportEvent.getInvalidAddresses()) + "; msg=" + LoggingTransportListener.getMessageString(emailDataTransportEvent.getMimeMessage());
    }

    @Override
    public void messageDelivered(@Nonnull EmailDataTransportEvent emailDataTransportEvent) {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Message delivered: " + LoggingTransportListener.getLogString(emailDataTransportEvent));
    }

    @Override
    public void messageNotDelivered(@Nonnull EmailDataTransportEvent emailDataTransportEvent) {
        LogHelper.log(LOGGER, this.m_aErrorLevel, "Message not delivered: " + LoggingTransportListener.getLogString(emailDataTransportEvent));
    }

    public String toString() {
        return new ToStringGenerator(this).getToString();
    }
}

