/*
 * Decompiled with CFR 0.152.
 */
package com.helger.smtp.util;

import com.helger.commons.email.EmailAddressHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;

@ThreadSafe
public final class EmailAddressValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailAddressValidator.class);
    private static final AtomicBoolean s_aPerformMXRecordCheck = new AtomicBoolean(false);
    private static final EmailAddressValidator s_aInstance = new EmailAddressValidator();

    private EmailAddressValidator() {
    }

    public static void setPerformMXRecordCheck(boolean bl) {
        s_aPerformMXRecordCheck.set(bl);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Email address record check is " + (bl ? "enabled" : "disabled"));
        }
    }

    public static boolean isPerformMXRecordCheck() {
        return s_aPerformMXRecordCheck.get();
    }

    private static boolean _hasMXRecord(@Nonnull String string) {
        try {
            Record[] recordArray = new Lookup(string, 15).run();
            return recordArray != null && recordArray.length > 0;
        }
        catch (Exception exception) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to check for MX record on host '" + string + "': " + exception.getClass().getName() + " - " + exception.getMessage());
            }
            return false;
        }
    }

    public static boolean isValid(@Nullable String string) {
        return s_aPerformMXRecordCheck.get() ? EmailAddressValidator.isValidWithMXCheck(string) : EmailAddressHelper.isValid(string);
    }

    public static boolean isValidWithMXCheck(@Nullable String string) {
        if (!EmailAddressHelper.isValid(string)) {
            return false;
        }
        String string2 = EmailAddressHelper.getUnifiedEmailAddress(string);
        int n = string2.indexOf(64);
        String string3 = string2.substring(n + 1);
        return EmailAddressValidator._hasMXRecord(string3);
    }
}

