/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tenancy.IBusinessObject;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractBusinessObject
implements IBusinessObject {
    private final String m_sID;
    private final LocalDateTime m_aCreationDT;
    private final String m_sCreationUserID;
    private LocalDateTime m_aLastModificationDT;
    private String m_sLastModificationUserID;
    private LocalDateTime m_aDeletionDT;
    private String m_sDeletionUserID;
    private final StringMap m_aAttrs = new StringMap();
    private transient int m_nHashCode = 0;

    public AbstractBusinessObject(@Nonnull IBusinessObject iBusinessObject) {
        this((String)iBusinessObject.getID(), iBusinessObject.getCreationDateTime(), iBusinessObject.getCreationUserID(), iBusinessObject.getLastModificationDateTime(), iBusinessObject.getLastModificationUserID(), iBusinessObject.getDeletionDateTime(), iBusinessObject.getDeletionUserID(), iBusinessObject.attrs());
    }

    public AbstractBusinessObject(@Nonnull @Nonempty String string, @Nullable LocalDateTime localDateTime, @Nullable String string2, @Nullable LocalDateTime localDateTime2, @Nullable String string3, @Nullable LocalDateTime localDateTime3, @Nullable String string4, @Nullable Map<String, String> map) {
        this.m_sID = ValueEnforcer.notEmpty(string, "ID");
        this.m_aCreationDT = localDateTime;
        this.m_sCreationUserID = string2;
        this.m_aLastModificationDT = localDateTime2;
        this.m_sLastModificationUserID = string3;
        this.m_aDeletionDT = localDateTime3;
        this.m_sDeletionUserID = string4;
        this.m_aAttrs.addAll(map);
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Override
    @Nullable
    public final LocalDateTime getCreationDateTime() {
        return this.m_aCreationDT;
    }

    @Override
    @Nullable
    public final String getCreationUserID() {
        return this.m_sCreationUserID;
    }

    @Override
    @Nullable
    public final LocalDateTime getLastModificationDateTime() {
        return this.m_aLastModificationDT;
    }

    @Override
    @Nullable
    public final String getLastModificationUserID() {
        return this.m_sLastModificationUserID;
    }

    public final void setLastModification(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(localDateTime, "LastModificationDT");
        ValueEnforcer.notEmpty(string, "LastModificationUserID");
        if (this.isDeleted()) {
            throw new IllegalStateException("Object is deleted and can therefore not be modified!");
        }
        this.m_aLastModificationDT = localDateTime;
        this.m_sLastModificationUserID = string;
    }

    @Override
    @Nullable
    public final LocalDateTime getDeletionDateTime() {
        return this.m_aDeletionDT;
    }

    @Override
    @Nullable
    public final String getDeletionUserID() {
        return this.m_sDeletionUserID;
    }

    @Nonnull
    public final EChange setDeletion(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(localDateTime, "DeletionDT");
        ValueEnforcer.notEmpty(string, "DeletionUserID");
        if (this.m_aDeletionDT != null) {
            return EChange.UNCHANGED;
        }
        this.m_aDeletionDT = localDateTime;
        this.m_sDeletionUserID = string;
        return EChange.CHANGED;
    }

    @Nonnull
    public final EChange setUndeletion(@Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(localDateTime, "UndeletionDT");
        ValueEnforcer.notEmpty(string, "UndeletionUserID");
        if (this.m_aDeletionDT == null) {
            return EChange.UNCHANGED;
        }
        this.m_aDeletionDT = null;
        this.m_sDeletionUserID = null;
        this.setLastModification(localDateTime, string);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final StringMap attrs() {
        return this.m_aAttrs;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractBusinessObject abstractBusinessObject = (AbstractBusinessObject)object;
        return this.getID().equals(abstractBusinessObject.getID());
    }

    public int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.getID()).getHashCode();
        }
        return n;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ID", this.m_sID).appendIfNotNull("CreationDT", this.m_aCreationDT).appendIfNotNull("CreationUserID", this.m_sCreationUserID).appendIfNotNull("LastModificationDT", this.m_aLastModificationDT).appendIfNotNull("LastModificationUserID", this.m_sLastModificationUserID).appendIfNotNull("DeletionDT", this.m_aDeletionDT).appendIfNotNull("DeletionUserID", this.m_sDeletionUserID).append("Attrs", this.m_aAttrs).getToString();
    }
}

