/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy.accarea;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tenancy.accarea.IAccountingArea;
import com.helger.tenancy.accarea.IAccountingAreaObject;
import com.helger.tenancy.accarea.IHasAccountingArea;
import com.helger.tenancy.tenant.AbstractHasTenant;
import com.helger.tenancy.tenant.ITenant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractHasAccountingAreaOptionalObject
extends AbstractHasTenant
implements IHasAccountingArea {
    private final IAccountingArea m_aAccountingArea;

    protected AbstractHasAccountingAreaOptionalObject(@Nonnull IAccountingAreaObject iAccountingAreaObject) {
        super(iAccountingAreaObject.getTenant());
        this.m_aAccountingArea = iAccountingAreaObject.getAccountingArea();
    }

    public AbstractHasAccountingAreaOptionalObject(@Nonnull IAccountingArea iAccountingArea) {
        this(iAccountingArea.getTenant(), iAccountingArea);
    }

    public AbstractHasAccountingAreaOptionalObject(@Nonnull ITenant iTenant, @Nullable IAccountingArea iAccountingArea) {
        super(iTenant);
        ValueEnforcer.notNull(iAccountingArea, "AccountingArea");
        if (iAccountingArea != null) {
            ValueEnforcer.isTrue(iAccountingArea.hasSameTenant(iTenant), () -> "The passed accounting area '" + (String)iAccountingArea.getID() + "' does not belong to the passed tenant '" + (String)iTenant.getID() + "'!");
        }
        this.m_aAccountingArea = iAccountingArea;
    }

    @Override
    @Nullable
    public final IAccountingArea getAccountingArea() {
        return this.m_aAccountingArea;
    }

    @Override
    @Nullable
    public final String getAccountingAreaID() {
        return this.m_aAccountingArea == null ? null : (String)this.m_aAccountingArea.getID();
    }

    @Override
    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingArea iAccountingArea) {
        return iAccountingArea != null && this.hasSameTenantID(iAccountingArea) && (this.m_aAccountingArea == null || this.hasSameAccountingAreaID((String)iAccountingArea.getID()));
    }

    @Override
    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingAreaObject iAccountingAreaObject) {
        return iAccountingAreaObject != null && this.hasSameTenantID(iAccountingAreaObject) && (this.m_aAccountingArea == null || this.hasSameAccountingAreaID(iAccountingAreaObject.getAccountingAreaID()));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        AbstractHasAccountingAreaOptionalObject abstractHasAccountingAreaOptionalObject = (AbstractHasAccountingAreaOptionalObject)object;
        return EqualsHelper.equals(this.m_aAccountingArea, abstractHasAccountingAreaOptionalObject.m_aAccountingArea);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aAccountingArea).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("accoutingArea", this.m_aAccountingArea).getToString();
    }
}

