/*
 * Decompiled with CFR 0.152.
 */
package com.helger.tenancy.tenant;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import com.helger.tenancy.tenant.ITenant;
import com.helger.tenancy.tenant.ITenantObject;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractTenantObject
extends AbstractBusinessObject
implements ITenantObject {
    private final ITenant m_aTenant;
    private transient int m_nHashCode = 0;

    protected AbstractTenantObject(@Nonnull ITenantObject iTenantObject) {
        super(iTenantObject);
        this.m_aTenant = iTenantObject.getTenant();
    }

    public AbstractTenantObject(@Nonnull ITenant iTenant, @Nonnull IBusinessObject iBusinessObject) {
        super(iBusinessObject);
        this.m_aTenant = ValueEnforcer.notNull(iTenant, "Tenant");
    }

    public AbstractTenantObject(@Nonnull ITenant iTenant, @Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nullable String string2, @Nullable LocalDateTime localDateTime2, @Nullable String string3, @Nullable LocalDateTime localDateTime3, @Nullable String string4) {
        super(string, localDateTime, string2, localDateTime2, string3, localDateTime3, string4, null);
        this.m_aTenant = ValueEnforcer.notNull(iTenant, "Tenant");
    }

    @Override
    @Nonnull
    public final ITenant getTenant() {
        return this.m_aTenant;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractTenantObject abstractTenantObject = (AbstractTenantObject)object;
        return this.m_aTenant.equals(abstractTenantObject.m_aTenant) && this.getID().equals(abstractTenantObject.getID());
    }

    @Override
    public final int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_aTenant).append(this.getID()).getHashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Tenant", this.m_aTenant).getToString();
    }
}

